/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.snowflake.client.jdbc.internal.apache.arrow.util.Preconditions;
import net.snowflake.client.jdbc.internal.io.netty.util.collection.IntObjectHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapWithOrdinal<K, V>
implements Map<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(MapWithOrdinal.class);
    private final Map<K, Map.Entry<Integer, V>> primary = new HashMap<K, Map.Entry<Integer, V>>();
    private final IntObjectHashMap<V> secondary = new IntObjectHashMap();
    private final Map<K, V> delegate = new Map<K, V>(){

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public int size() {
            return MapWithOrdinal.this.primary.size();
        }

        @Override
        public boolean containsKey(Object key) {
            return MapWithOrdinal.this.primary.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return MapWithOrdinal.this.primary.containsValue(value);
        }

        @Override
        public V get(Object key) {
            Map.Entry pair = (Map.Entry)MapWithOrdinal.this.primary.get(key);
            if (pair != null) {
                return pair.getValue();
            }
            return null;
        }

        @Override
        public V put(K key, V value) {
            Map.Entry oldPair = (Map.Entry)MapWithOrdinal.this.primary.get(key);
            int ordinal = oldPair == null ? MapWithOrdinal.this.primary.size() : ((Integer)oldPair.getKey()).intValue();
            MapWithOrdinal.this.primary.put(key, new AbstractMap.SimpleImmutableEntry(ordinal, value));
            MapWithOrdinal.this.secondary.put(ordinal, value);
            return oldPair == null ? null : (Object)oldPair.getValue();
        }

        @Override
        public V remove(Object key) {
            Map.Entry oldPair = (Map.Entry)MapWithOrdinal.this.primary.remove(key);
            if (oldPair != null) {
                int lastOrdinal = MapWithOrdinal.this.secondary.size();
                Object last = MapWithOrdinal.this.secondary.get(lastOrdinal);
                MapWithOrdinal.this.secondary.put((Integer)oldPair.getKey(), last);
                MapWithOrdinal.this.primary.put(key, new AbstractMap.SimpleImmutableEntry(oldPair.getKey(), last));
            }
            return oldPair == null ? null : (Object)oldPair.getValue();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            MapWithOrdinal.this.primary.clear();
            MapWithOrdinal.this.secondary.clear();
        }

        @Override
        public Set<K> keySet() {
            return MapWithOrdinal.this.primary.keySet();
        }

        @Override
        public Collection<V> values() {
            return StreamSupport.stream(MapWithOrdinal.this.secondary.entries().spliterator(), false).map(t -> Preconditions.checkNotNull(t).value()).collect(Collectors.toList());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return MapWithOrdinal.this.primary.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry(entry.getKey(), ((Map.Entry)entry.getValue()).getValue())).collect(Collectors.toSet());
        }
    };

    public V getByOrdinal(int id) {
        return this.secondary.get(id);
    }

    public int getOrdinal(K key) {
        Map.Entry<Integer, V> pair = this.primary.get(key);
        if (pair != null) {
            return pair.getKey();
        }
        return -1;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.delegate.put(key, value);
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    public List<K> keyList() {
        int size = this.size();
        Set<K> keys = this.keySet();
        ArrayList<K> children = new ArrayList<K>(size);
        for (K key : keys) {
            children.add(this.getOrdinal(key), key);
        }
        return children;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }
}

