/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.types;

import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BigIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DateDayVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DateMilliVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DecimalVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FixedSizeBinaryVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.Float4Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.Float8Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntervalDayVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntervalYearVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.SmallIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeMicroVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeMilliVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeNanoVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeSecVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampMicroTZVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampMicroVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampMilliTZVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampMilliVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampNanoTZVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampNanoVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampSecTZVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampSecVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TinyIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.UInt1Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.UInt2Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.UInt4Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.UInt8Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VarBinaryVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VarCharVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ZeroVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.FixedSizeListVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.ListVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.StructVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.UnionVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.BigIntWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.BitWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.DateDayWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.DateMilliWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.DecimalWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.FixedSizeBinaryWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.Float4WriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.Float8WriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.IntWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.IntervalDayWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.IntervalYearWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.NullableStructWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.SmallIntWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.TimeMicroWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.TimeMilliWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.TimeNanoWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.TimeSecWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.TimeStampMicroTZWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.TimeStampMicroWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.TimeStampMilliTZWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.TimeStampMilliWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.TimeStampNanoTZWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.TimeStampNanoWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.TimeStampSecTZWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.TimeStampSecWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.TinyIntWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.UInt1WriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.UInt2WriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.UInt4WriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.UInt8WriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.UnionListWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.UnionWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.VarBinaryWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.VarCharWriterImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.FieldWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.DateUnit;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.FloatingPointPrecision;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.IntervalUnit;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.TimeUnit;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.UnionMode;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.ArrowType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.CallBack;

public class Types {
    public static MinorType getMinorTypeForArrowType(ArrowType arrowType) {
        return arrowType.accept(new ArrowType.ArrowTypeVisitor<MinorType>(){

            @Override
            public MinorType visit(ArrowType.Null type) {
                return MinorType.NULL;
            }

            @Override
            public MinorType visit(ArrowType.Struct type) {
                return MinorType.STRUCT;
            }

            @Override
            public MinorType visit(ArrowType.List type) {
                return MinorType.LIST;
            }

            @Override
            public MinorType visit(ArrowType.FixedSizeList type) {
                return MinorType.FIXED_SIZE_LIST;
            }

            @Override
            public MinorType visit(ArrowType.Union type) {
                return MinorType.UNION;
            }

            @Override
            public MinorType visit(ArrowType.Int type) {
                switch (type.getBitWidth()) {
                    case 8: {
                        return type.getIsSigned() ? MinorType.TINYINT : MinorType.UINT1;
                    }
                    case 16: {
                        return type.getIsSigned() ? MinorType.SMALLINT : MinorType.UINT2;
                    }
                    case 32: {
                        return type.getIsSigned() ? MinorType.INT : MinorType.UINT4;
                    }
                    case 64: {
                        return type.getIsSigned() ? MinorType.BIGINT : MinorType.UINT8;
                    }
                }
                throw new IllegalArgumentException("only 8, 16, 32, 64 supported: " + type);
            }

            @Override
            public MinorType visit(ArrowType.FloatingPoint type) {
                switch (type.getPrecision()) {
                    case HALF: {
                        throw new UnsupportedOperationException("NYI: " + type);
                    }
                    case SINGLE: {
                        return MinorType.FLOAT4;
                    }
                    case DOUBLE: {
                        return MinorType.FLOAT8;
                    }
                }
                throw new IllegalArgumentException("unknown precision: " + type);
            }

            @Override
            public MinorType visit(ArrowType.Utf8 type) {
                return MinorType.VARCHAR;
            }

            @Override
            public MinorType visit(ArrowType.Binary type) {
                return MinorType.VARBINARY;
            }

            @Override
            public MinorType visit(ArrowType.Bool type) {
                return MinorType.BIT;
            }

            @Override
            public MinorType visit(ArrowType.Decimal type) {
                return MinorType.DECIMAL;
            }

            @Override
            public MinorType visit(ArrowType.FixedSizeBinary type) {
                return MinorType.FIXEDSIZEBINARY;
            }

            @Override
            public MinorType visit(ArrowType.Date type) {
                switch (type.getUnit()) {
                    case DAY: {
                        return MinorType.DATEDAY;
                    }
                    case MILLISECOND: {
                        return MinorType.DATEMILLI;
                    }
                }
                throw new IllegalArgumentException("unknown unit: " + type);
            }

            @Override
            public MinorType visit(ArrowType.Time type) {
                switch (type.getUnit()) {
                    case SECOND: {
                        return MinorType.TIMESEC;
                    }
                    case MILLISECOND: {
                        return MinorType.TIMEMILLI;
                    }
                    case MICROSECOND: {
                        return MinorType.TIMEMICRO;
                    }
                    case NANOSECOND: {
                        return MinorType.TIMENANO;
                    }
                }
                throw new IllegalArgumentException("unknown unit: " + type);
            }

            @Override
            public MinorType visit(ArrowType.Timestamp type) {
                String tz = type.getTimezone();
                switch (type.getUnit()) {
                    case SECOND: {
                        return tz == null ? MinorType.TIMESTAMPSEC : MinorType.TIMESTAMPSECTZ;
                    }
                    case MILLISECOND: {
                        return tz == null ? MinorType.TIMESTAMPMILLI : MinorType.TIMESTAMPMILLITZ;
                    }
                    case MICROSECOND: {
                        return tz == null ? MinorType.TIMESTAMPMICRO : MinorType.TIMESTAMPMICROTZ;
                    }
                    case NANOSECOND: {
                        return tz == null ? MinorType.TIMESTAMPNANO : MinorType.TIMESTAMPNANOTZ;
                    }
                }
                throw new IllegalArgumentException("unknown unit: " + type);
            }

            @Override
            public MinorType visit(ArrowType.Interval type) {
                switch (type.getUnit()) {
                    case DAY_TIME: {
                        return MinorType.INTERVALDAY;
                    }
                    case YEAR_MONTH: {
                        return MinorType.INTERVALYEAR;
                    }
                }
                throw new IllegalArgumentException("unknown unit: " + type);
            }
        });
    }

    public static enum MinorType {
        NULL(ArrowType.Null.INSTANCE){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return ZeroVector.INSTANCE;
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return null;
            }
        }
        ,
        STRUCT(ArrowType.Struct.INSTANCE){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new StructVector(name, allocator, fieldType, schemaChangeCallback);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new NullableStructWriter((StructVector)vector);
            }
        }
        ,
        TINYINT(new ArrowType.Int(8, true)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TinyIntVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TinyIntWriterImpl((TinyIntVector)vector);
            }
        }
        ,
        SMALLINT(new ArrowType.Int(16, true)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new SmallIntVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new SmallIntWriterImpl((SmallIntVector)vector);
            }
        }
        ,
        INT(new ArrowType.Int(32, true)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new IntVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new IntWriterImpl((IntVector)vector);
            }
        }
        ,
        BIGINT(new ArrowType.Int(64, true)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new BigIntVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new BigIntWriterImpl((BigIntVector)vector);
            }
        }
        ,
        DATEDAY(new ArrowType.Date(DateUnit.DAY)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new DateDayVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new DateDayWriterImpl((DateDayVector)vector);
            }
        }
        ,
        DATEMILLI(new ArrowType.Date(DateUnit.MILLISECOND)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new DateMilliVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new DateMilliWriterImpl((DateMilliVector)vector);
            }
        }
        ,
        TIMESEC(new ArrowType.Time(TimeUnit.SECOND, 32)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeSecVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeSecWriterImpl((TimeSecVector)vector);
            }
        }
        ,
        TIMEMILLI(new ArrowType.Time(TimeUnit.MILLISECOND, 32)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeMilliVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeMilliWriterImpl((TimeMilliVector)vector);
            }
        }
        ,
        TIMEMICRO(new ArrowType.Time(TimeUnit.MICROSECOND, 64)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeMicroVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeMicroWriterImpl((TimeMicroVector)vector);
            }
        }
        ,
        TIMENANO(new ArrowType.Time(TimeUnit.NANOSECOND, 64)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeNanoVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeNanoWriterImpl((TimeNanoVector)vector);
            }
        }
        ,
        TIMESTAMPSEC(new ArrowType.Timestamp(TimeUnit.SECOND, null)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeStampSecVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeStampSecWriterImpl((TimeStampSecVector)vector);
            }
        }
        ,
        TIMESTAMPMILLI(new ArrowType.Timestamp(TimeUnit.MILLISECOND, null)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeStampMilliVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeStampMilliWriterImpl((TimeStampMilliVector)vector);
            }
        }
        ,
        TIMESTAMPMICRO(new ArrowType.Timestamp(TimeUnit.MICROSECOND, null)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeStampMicroVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeStampMicroWriterImpl((TimeStampMicroVector)vector);
            }
        }
        ,
        TIMESTAMPNANO(new ArrowType.Timestamp(TimeUnit.NANOSECOND, null)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeStampNanoVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeStampNanoWriterImpl((TimeStampNanoVector)vector);
            }
        }
        ,
        INTERVALDAY(new ArrowType.Interval(IntervalUnit.DAY_TIME)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new IntervalDayVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new IntervalDayWriterImpl((IntervalDayVector)vector);
            }
        }
        ,
        INTERVALYEAR(new ArrowType.Interval(IntervalUnit.YEAR_MONTH)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new IntervalYearVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new IntervalYearWriterImpl((IntervalYearVector)vector);
            }
        }
        ,
        FLOAT4(new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new Float4Vector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new Float4WriterImpl((Float4Vector)vector);
            }
        }
        ,
        FLOAT8(new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new Float8Vector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new Float8WriterImpl((Float8Vector)vector);
            }
        }
        ,
        BIT(ArrowType.Bool.INSTANCE){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new BitVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new BitWriterImpl((BitVector)vector);
            }
        }
        ,
        VARCHAR(ArrowType.Utf8.INSTANCE){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new VarCharVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new VarCharWriterImpl((VarCharVector)vector);
            }
        }
        ,
        VARBINARY(ArrowType.Binary.INSTANCE){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new VarBinaryVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new VarBinaryWriterImpl((VarBinaryVector)vector);
            }
        }
        ,
        DECIMAL(null){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new DecimalVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new DecimalWriterImpl((DecimalVector)vector);
            }
        }
        ,
        FIXEDSIZEBINARY(null){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new FixedSizeBinaryVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new FixedSizeBinaryWriterImpl((FixedSizeBinaryVector)vector);
            }
        }
        ,
        UINT1(new ArrowType.Int(8, false)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new UInt1Vector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new UInt1WriterImpl((UInt1Vector)vector);
            }
        }
        ,
        UINT2(new ArrowType.Int(16, false)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new UInt2Vector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new UInt2WriterImpl((UInt2Vector)vector);
            }
        }
        ,
        UINT4(new ArrowType.Int(32, false)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new UInt4Vector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new UInt4WriterImpl((UInt4Vector)vector);
            }
        }
        ,
        UINT8(new ArrowType.Int(64, false)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new UInt8Vector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new UInt8WriterImpl((UInt8Vector)vector);
            }
        }
        ,
        LIST(ArrowType.List.INSTANCE){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new ListVector(name, allocator, fieldType, schemaChangeCallback);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new UnionListWriter((ListVector)vector);
            }
        }
        ,
        FIXED_SIZE_LIST(null){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new FixedSizeListVector(name, allocator, fieldType, schemaChangeCallback);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                throw new UnsupportedOperationException("FieldWriter not implemented for FixedSizeList type");
            }
        }
        ,
        UNION(new ArrowType.Union(UnionMode.Sparse, null)){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                if (fieldType.getDictionary() != null) {
                    throw new UnsupportedOperationException("Dictionary encoding not supported for complex types");
                }
                return new UnionVector(name, allocator, schemaChangeCallback);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new UnionWriter((UnionVector)vector);
            }
        }
        ,
        TIMESTAMPSECTZ(null){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeStampSecTZVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeStampSecTZWriterImpl((TimeStampSecTZVector)vector);
            }
        }
        ,
        TIMESTAMPMILLITZ(null){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeStampMilliTZVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeStampMilliTZWriterImpl((TimeStampMilliTZVector)vector);
            }
        }
        ,
        TIMESTAMPMICROTZ(null){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeStampMicroTZVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeStampMicroTZWriterImpl((TimeStampMicroTZVector)vector);
            }
        }
        ,
        TIMESTAMPNANOTZ(null){

            @Override
            public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator, CallBack schemaChangeCallback) {
                return new TimeStampNanoTZVector(name, fieldType, allocator);
            }

            @Override
            public FieldWriter getNewFieldWriter(ValueVector vector) {
                return new TimeStampNanoTZWriterImpl((TimeStampNanoTZVector)vector);
            }
        };

        private final ArrowType type;

        private MinorType(ArrowType type) {
            this.type = type;
        }

        public final ArrowType getType() {
            if (this.type == null) {
                throw new UnsupportedOperationException("Cannot get simple type for type " + this.name());
            }
            return this.type;
        }

        public abstract FieldVector getNewVector(String var1, FieldType var2, BufferAllocator var3, CallBack var4);

        public abstract FieldWriter getNewFieldWriter(ValueVector var1);
    }
}

