/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl;

import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.BaseWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.FieldWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableBigIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableBitHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableDateDayHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableDateMilliHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableFloat4Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableFloat8Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableIntervalDayHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableIntervalYearHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableSmallIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeMicroHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeMilliHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeNanoHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeSecHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeStampMicroHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeStampMilliHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeStampNanoHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeStampSecHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTinyIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableUInt1Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableUInt2Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableUInt4Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableUInt8Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableVarBinaryHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableVarCharHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;

public class ComplexCopier {
    public static void copy(FieldReader input, FieldWriter output) {
        ComplexCopier.writeValue(input, output);
    }

    private static void writeValue(FieldReader reader, FieldWriter writer) {
        Types.MinorType mt = reader.getMinorType();
        switch (mt) {
            case LIST: {
                if (!reader.isSet()) break;
                writer.startList();
                while (reader.next()) {
                    ComplexCopier.writeValue(reader.reader(), ComplexCopier.getListWriterForReader(reader.reader(), writer));
                }
                writer.endList();
                break;
            }
            case FIXED_SIZE_LIST: {
                throw new UnsupportedOperationException("Copy fixed size list");
            }
            case STRUCT: {
                if (!reader.isSet()) break;
                writer.start();
                for (String name : reader) {
                    FieldReader childReader = reader.reader(name);
                    if (!childReader.isSet()) continue;
                    ComplexCopier.writeValue(childReader, ComplexCopier.getStructWriterForReader(childReader, writer, name));
                }
                writer.end();
                break;
            }
            case TINYINT: {
                if (!reader.isSet()) break;
                NullableTinyIntHolder tinyIntHolder = new NullableTinyIntHolder();
                reader.read(tinyIntHolder);
                if (tinyIntHolder.isSet != 1) break;
                writer.writeTinyInt(tinyIntHolder.value);
                break;
            }
            case UINT1: {
                if (!reader.isSet()) break;
                NullableUInt1Holder uInt1Holder = new NullableUInt1Holder();
                reader.read(uInt1Holder);
                if (uInt1Holder.isSet != 1) break;
                writer.writeUInt1(uInt1Holder.value);
                break;
            }
            case UINT2: {
                if (!reader.isSet()) break;
                NullableUInt2Holder uInt2Holder = new NullableUInt2Holder();
                reader.read(uInt2Holder);
                if (uInt2Holder.isSet != 1) break;
                writer.writeUInt2(uInt2Holder.value);
                break;
            }
            case SMALLINT: {
                if (!reader.isSet()) break;
                NullableSmallIntHolder smallIntHolder = new NullableSmallIntHolder();
                reader.read(smallIntHolder);
                if (smallIntHolder.isSet != 1) break;
                writer.writeSmallInt(smallIntHolder.value);
                break;
            }
            case INT: {
                if (!reader.isSet()) break;
                NullableIntHolder intHolder = new NullableIntHolder();
                reader.read(intHolder);
                if (intHolder.isSet != 1) break;
                writer.writeInt(intHolder.value);
                break;
            }
            case UINT4: {
                if (!reader.isSet()) break;
                NullableUInt4Holder uInt4Holder = new NullableUInt4Holder();
                reader.read(uInt4Holder);
                if (uInt4Holder.isSet != 1) break;
                writer.writeUInt4(uInt4Holder.value);
                break;
            }
            case FLOAT4: {
                if (!reader.isSet()) break;
                NullableFloat4Holder float4Holder = new NullableFloat4Holder();
                reader.read(float4Holder);
                if (float4Holder.isSet != 1) break;
                writer.writeFloat4(float4Holder.value);
                break;
            }
            case DATEDAY: {
                if (!reader.isSet()) break;
                NullableDateDayHolder dateDayHolder = new NullableDateDayHolder();
                reader.read(dateDayHolder);
                if (dateDayHolder.isSet != 1) break;
                writer.writeDateDay(dateDayHolder.value);
                break;
            }
            case INTERVALYEAR: {
                if (!reader.isSet()) break;
                NullableIntervalYearHolder intervalYearHolder = new NullableIntervalYearHolder();
                reader.read(intervalYearHolder);
                if (intervalYearHolder.isSet != 1) break;
                writer.writeIntervalYear(intervalYearHolder.value);
                break;
            }
            case TIMESEC: {
                if (!reader.isSet()) break;
                NullableTimeSecHolder timeSecHolder = new NullableTimeSecHolder();
                reader.read(timeSecHolder);
                if (timeSecHolder.isSet != 1) break;
                writer.writeTimeSec(timeSecHolder.value);
                break;
            }
            case TIMEMILLI: {
                if (!reader.isSet()) break;
                NullableTimeMilliHolder timeMilliHolder = new NullableTimeMilliHolder();
                reader.read(timeMilliHolder);
                if (timeMilliHolder.isSet != 1) break;
                writer.writeTimeMilli(timeMilliHolder.value);
                break;
            }
            case BIGINT: {
                if (!reader.isSet()) break;
                NullableBigIntHolder bigIntHolder = new NullableBigIntHolder();
                reader.read(bigIntHolder);
                if (bigIntHolder.isSet != 1) break;
                writer.writeBigInt(bigIntHolder.value);
                break;
            }
            case UINT8: {
                if (!reader.isSet()) break;
                NullableUInt8Holder uInt8Holder = new NullableUInt8Holder();
                reader.read(uInt8Holder);
                if (uInt8Holder.isSet != 1) break;
                writer.writeUInt8(uInt8Holder.value);
                break;
            }
            case FLOAT8: {
                if (!reader.isSet()) break;
                NullableFloat8Holder float8Holder = new NullableFloat8Holder();
                reader.read(float8Holder);
                if (float8Holder.isSet != 1) break;
                writer.writeFloat8(float8Holder.value);
                break;
            }
            case DATEMILLI: {
                if (!reader.isSet()) break;
                NullableDateMilliHolder dateMilliHolder = new NullableDateMilliHolder();
                reader.read(dateMilliHolder);
                if (dateMilliHolder.isSet != 1) break;
                writer.writeDateMilli(dateMilliHolder.value);
                break;
            }
            case TIMESTAMPSEC: {
                if (!reader.isSet()) break;
                NullableTimeStampSecHolder timeStampSecHolder = new NullableTimeStampSecHolder();
                reader.read(timeStampSecHolder);
                if (timeStampSecHolder.isSet != 1) break;
                writer.writeTimeStampSec(timeStampSecHolder.value);
                break;
            }
            case TIMESTAMPMILLI: {
                if (!reader.isSet()) break;
                NullableTimeStampMilliHolder timeStampMilliHolder = new NullableTimeStampMilliHolder();
                reader.read(timeStampMilliHolder);
                if (timeStampMilliHolder.isSet != 1) break;
                writer.writeTimeStampMilli(timeStampMilliHolder.value);
                break;
            }
            case TIMESTAMPMICRO: {
                if (!reader.isSet()) break;
                NullableTimeStampMicroHolder timeStampMicroHolder = new NullableTimeStampMicroHolder();
                reader.read(timeStampMicroHolder);
                if (timeStampMicroHolder.isSet != 1) break;
                writer.writeTimeStampMicro(timeStampMicroHolder.value);
                break;
            }
            case TIMESTAMPNANO: {
                if (!reader.isSet()) break;
                NullableTimeStampNanoHolder timeStampNanoHolder = new NullableTimeStampNanoHolder();
                reader.read(timeStampNanoHolder);
                if (timeStampNanoHolder.isSet != 1) break;
                writer.writeTimeStampNano(timeStampNanoHolder.value);
                break;
            }
            case TIMEMICRO: {
                if (!reader.isSet()) break;
                NullableTimeMicroHolder timeMicroHolder = new NullableTimeMicroHolder();
                reader.read(timeMicroHolder);
                if (timeMicroHolder.isSet != 1) break;
                writer.writeTimeMicro(timeMicroHolder.value);
                break;
            }
            case TIMENANO: {
                if (!reader.isSet()) break;
                NullableTimeNanoHolder timeNanoHolder = new NullableTimeNanoHolder();
                reader.read(timeNanoHolder);
                if (timeNanoHolder.isSet != 1) break;
                writer.writeTimeNano(timeNanoHolder.value);
                break;
            }
            case INTERVALDAY: {
                if (!reader.isSet()) break;
                NullableIntervalDayHolder intervalDayHolder = new NullableIntervalDayHolder();
                reader.read(intervalDayHolder);
                if (intervalDayHolder.isSet != 1) break;
                writer.writeIntervalDay(intervalDayHolder.days, intervalDayHolder.milliseconds);
                break;
            }
            case VARBINARY: {
                if (!reader.isSet()) break;
                NullableVarBinaryHolder varBinaryHolder = new NullableVarBinaryHolder();
                reader.read(varBinaryHolder);
                if (varBinaryHolder.isSet != 1) break;
                writer.writeVarBinary(varBinaryHolder.start, varBinaryHolder.end, varBinaryHolder.buffer);
                break;
            }
            case VARCHAR: {
                if (!reader.isSet()) break;
                NullableVarCharHolder varCharHolder = new NullableVarCharHolder();
                reader.read(varCharHolder);
                if (varCharHolder.isSet != 1) break;
                writer.writeVarChar(varCharHolder.start, varCharHolder.end, varCharHolder.buffer);
                break;
            }
            case BIT: {
                if (!reader.isSet()) break;
                NullableBitHolder bitHolder = new NullableBitHolder();
                reader.read(bitHolder);
                if (bitHolder.isSet != 1) break;
                writer.writeBit(bitHolder.value);
            }
        }
    }

    private static FieldWriter getStructWriterForReader(FieldReader reader, BaseWriter.StructWriter writer, String name) {
        switch (reader.getMinorType()) {
            case TINYINT: {
                return (FieldWriter)writer.tinyInt(name);
            }
            case UINT1: {
                return (FieldWriter)writer.uInt1(name);
            }
            case UINT2: {
                return (FieldWriter)writer.uInt2(name);
            }
            case SMALLINT: {
                return (FieldWriter)writer.smallInt(name);
            }
            case INT: {
                return (FieldWriter)writer.integer(name);
            }
            case UINT4: {
                return (FieldWriter)writer.uInt4(name);
            }
            case FLOAT4: {
                return (FieldWriter)writer.float4(name);
            }
            case DATEDAY: {
                return (FieldWriter)writer.dateDay(name);
            }
            case INTERVALYEAR: {
                return (FieldWriter)writer.intervalYear(name);
            }
            case TIMESEC: {
                return (FieldWriter)writer.timeSec(name);
            }
            case TIMEMILLI: {
                return (FieldWriter)writer.timeMilli(name);
            }
            case BIGINT: {
                return (FieldWriter)writer.bigInt(name);
            }
            case UINT8: {
                return (FieldWriter)writer.uInt8(name);
            }
            case FLOAT8: {
                return (FieldWriter)writer.float8(name);
            }
            case DATEMILLI: {
                return (FieldWriter)writer.dateMilli(name);
            }
            case TIMESTAMPSEC: {
                return (FieldWriter)writer.timeStampSec(name);
            }
            case TIMESTAMPMILLI: {
                return (FieldWriter)writer.timeStampMilli(name);
            }
            case TIMESTAMPMICRO: {
                return (FieldWriter)writer.timeStampMicro(name);
            }
            case TIMESTAMPNANO: {
                return (FieldWriter)writer.timeStampNano(name);
            }
            case TIMEMICRO: {
                return (FieldWriter)writer.timeMicro(name);
            }
            case TIMENANO: {
                return (FieldWriter)writer.timeNano(name);
            }
            case INTERVALDAY: {
                return (FieldWriter)writer.intervalDay(name);
            }
            case VARBINARY: {
                return (FieldWriter)writer.varBinary(name);
            }
            case VARCHAR: {
                return (FieldWriter)writer.varChar(name);
            }
            case BIT: {
                return (FieldWriter)writer.bit(name);
            }
            case STRUCT: {
                return (FieldWriter)writer.struct(name);
            }
            case LIST: {
                return (FieldWriter)writer.list(name);
            }
        }
        throw new UnsupportedOperationException(reader.getMinorType().toString());
    }

    private static FieldWriter getListWriterForReader(FieldReader reader, BaseWriter.ListWriter writer) {
        switch (reader.getMinorType()) {
            case TINYINT: {
                return (FieldWriter)writer.tinyInt();
            }
            case UINT1: {
                return (FieldWriter)writer.uInt1();
            }
            case UINT2: {
                return (FieldWriter)writer.uInt2();
            }
            case SMALLINT: {
                return (FieldWriter)writer.smallInt();
            }
            case INT: {
                return (FieldWriter)writer.integer();
            }
            case UINT4: {
                return (FieldWriter)writer.uInt4();
            }
            case FLOAT4: {
                return (FieldWriter)writer.float4();
            }
            case DATEDAY: {
                return (FieldWriter)writer.dateDay();
            }
            case INTERVALYEAR: {
                return (FieldWriter)writer.intervalYear();
            }
            case TIMESEC: {
                return (FieldWriter)writer.timeSec();
            }
            case TIMEMILLI: {
                return (FieldWriter)writer.timeMilli();
            }
            case BIGINT: {
                return (FieldWriter)writer.bigInt();
            }
            case UINT8: {
                return (FieldWriter)writer.uInt8();
            }
            case FLOAT8: {
                return (FieldWriter)writer.float8();
            }
            case DATEMILLI: {
                return (FieldWriter)writer.dateMilli();
            }
            case TIMESTAMPSEC: {
                return (FieldWriter)writer.timeStampSec();
            }
            case TIMESTAMPMILLI: {
                return (FieldWriter)writer.timeStampMilli();
            }
            case TIMESTAMPMICRO: {
                return (FieldWriter)writer.timeStampMicro();
            }
            case TIMESTAMPNANO: {
                return (FieldWriter)writer.timeStampNano();
            }
            case TIMEMICRO: {
                return (FieldWriter)writer.timeMicro();
            }
            case TIMENANO: {
                return (FieldWriter)writer.timeNano();
            }
            case INTERVALDAY: {
                return (FieldWriter)writer.intervalDay();
            }
            case VARBINARY: {
                return (FieldWriter)writer.varBinary();
            }
            case VARCHAR: {
                return (FieldWriter)writer.varChar();
            }
            case BIT: {
                return (FieldWriter)writer.bit();
            }
            case STRUCT: {
                return (FieldWriter)writer.struct();
            }
            case LIST: {
                return (FieldWriter)writer.list();
            }
        }
        throw new UnsupportedOperationException(reader.getMinorType().toString());
    }
}

