/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.util.Map;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.cloud.storage.AzureObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.S3ObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeAzureClient;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeS3Client;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeStorageClient;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.ClientConfiguration;
import net.snowflake.client.jdbc.internal.snowflake.common.core.RemoteStoreFileEncryptionMaterial;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class StorageClientFactory {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeS3Client.class);
    private static StorageClientFactory factory;

    private StorageClientFactory() {
    }

    public static StorageClientFactory getFactory() {
        if (factory == null) {
            factory = new StorageClientFactory();
        }
        return factory;
    }

    public SnowflakeStorageClient createClient(StageInfo stage, int parallel, RemoteStoreFileEncryptionMaterial encMat) throws SnowflakeSQLException {
        logger.debug("createClient client type={}", stage.getStageType().name());
        switch (stage.getStageType()) {
            case S3: {
                return this.createS3Client(stage.getCredentials(), parallel, encMat, stage.getRegion());
            }
            case AZURE: {
                return this.createAzureClient(stage, encMat);
            }
        }
        throw new IllegalArgumentException("Unsupported storage client specified: " + stage.getStageType().name());
    }

    private SnowflakeS3Client createS3Client(Map<?, ?> stageCredentials, int parallel, RemoteStoreFileEncryptionMaterial encMat, String stageRegion) throws SnowflakeSQLException {
        SnowflakeS3Client s3Client;
        int S3_TRANSFER_MAX_RETRIES = 3;
        logger.debug("createS3Client encryption={}", encMat == null ? "no" : "yes");
        ClientConfiguration clientConfig = new ClientConfiguration();
        clientConfig.setMaxConnections(parallel + 1);
        clientConfig.setMaxErrorRetry(3);
        clientConfig.setDisableSocketProxy(HttpUtil.isSocksProxyDisabled());
        logger.debug("s3 client configuration: maxConnection={}, connectionTimeout={}, socketTimeout={}, maxErrorRetry={}", clientConfig.getMaxConnections(), clientConfig.getConnectionTimeout(), clientConfig.getSocketTimeout(), clientConfig.getMaxErrorRetry());
        try {
            s3Client = new SnowflakeS3Client(stageCredentials, clientConfig, encMat, stageRegion);
        }
        catch (Exception ex) {
            logger.debug("Exception creating s3 client", ex);
            throw ex;
        }
        logger.debug("s3 client created");
        return s3Client;
    }

    public StorageObjectMetadata createStorageMetadataObj(StageInfo.StageType stageType) {
        switch (stageType) {
            case S3: {
                return new S3ObjectMetadata();
            }
            case AZURE: {
                return new AzureObjectMetadata();
            }
        }
        throw new IllegalArgumentException("Unsupported stage type specified: " + stageType.name());
    }

    private SnowflakeAzureClient createAzureClient(StageInfo stage, RemoteStoreFileEncryptionMaterial encMat) throws SnowflakeSQLException {
        SnowflakeAzureClient azureClient;
        logger.debug("createAzureClient encryption={}", encMat == null ? "no" : "yes");
        try {
            azureClient = SnowflakeAzureClient.createSnowflakeAzureClient(stage, encMat);
        }
        catch (Exception ex) {
            logger.debug("Exception creating Azure Storage client", ex);
            throw ex;
        }
        logger.debug("Azure Storage client created");
        return azureClient;
    }
}

