/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

public class BitToBooleanConverter
extends AbstractArrowVectorConverter {
    private BitVector bitVector;

    public BitToBooleanConverter(ValueVector fieldVector, int columnIndex, DataConversionContext context) {
        super(SnowflakeType.BOOLEAN.name(), fieldVector, columnIndex, context);
        this.bitVector = (BitVector)fieldVector;
    }

    private int getBit(int index) {
        int byteIndex = index >> 3;
        byte b = this.bitVector.getDataBuffer().getByte(byteIndex);
        int bitIndex = index & 7;
        return b >> bitIndex & 1;
    }

    @Override
    public boolean toBoolean(int index) {
        if (this.isNull(index)) {
            return false;
        }
        return this.getBit(index) != 0;
    }

    @Override
    public Object toObject(int index) {
        return this.toBoolean(index);
    }

    @Override
    public String toString(int index) {
        return this.isNull(index) ? null : String.valueOf(this.toBoolean(index));
    }
}

