/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec;

import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsKDF;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec.KTSKeySpec;

public class KTSGenerateKeySpec
extends KTSKeySpec {
    private final PublicKey publicKey;
    private final SecureRandom random;

    private KTSGenerateKeySpec(PublicKey publicKey, String string, int n, SecureRandom secureRandom, String string2, int n2, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        super(string, n, string2, n2, algorithmParameterSpec, algorithmIdentifier, byArray);
        this.publicKey = publicKey;
        this.random = secureRandom;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public SecureRandom getSecureRandom() {
        return this.random;
    }

    public static final class Builder {
        private final PublicKey publicKey;
        private final String algorithmName;
        private final int keySizeInBits;
        private String macAlgorithm;
        private int macKeySizeInBits;
        private SecureRandom random;
        private AlgorithmParameterSpec parameterSpec;
        private AlgorithmIdentifier kdfAlgorithm;
        private byte[] otherInfo;

        public Builder(PublicKey publicKey, String string, int n) {
            this(publicKey, string, n, null);
        }

        public Builder(PublicKey publicKey, String string, int n, byte[] byArray) {
            this.publicKey = publicKey;
            this.algorithmName = string;
            this.keySizeInBits = n;
            this.kdfAlgorithm = KTSKeySpec.createAlgId(KTSKeySpec.KDF3.withPRF(FipsKDF.AgreementKDFPRF.SHA256));
            this.otherInfo = KTSKeySpec.copyOtherInfo(byArray);
        }

        public Builder withSecureRandom(SecureRandom secureRandom) {
            this.random = secureRandom;
            return this;
        }

        public Builder withMac(String string, int n) {
            this.macAlgorithm = string;
            this.macKeySizeInBits = n;
            if (string != null && n <= 0) {
                throw new IllegalArgumentException("macKeySizeInBits must be greater than zero");
            }
            return this;
        }

        public Builder withParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
            this.parameterSpec = algorithmParameterSpec;
            return this;
        }

        public Builder withKdfAlgorithm(FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder) {
            this.kdfAlgorithm = KTSKeySpec.createAlgId(agreementKDFParametersBuilder);
            return this;
        }

        public Builder withKdfAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
            this.kdfAlgorithm = algorithmIdentifier;
            return this;
        }

        public KTSGenerateKeySpec build() {
            return new KTSGenerateKeySpec(this.publicKey, this.algorithmName, this.keySizeInBits, this.random, this.macAlgorithm, this.macKeySizeInBits, this.parameterSpec, this.kdfAlgorithm, this.otherInfo);
        }
    }
}

