/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider;

import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsSecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.EngineCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Arrays;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Pack;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Strings;

class ProvRandom
extends AsymmetricAlgorithmProvider {
    private static final String PREFIX = "net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.random.";

    ProvRandom() {
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecureRandom.DEFAULT", "net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.random.DefSecureRandom", new EngineCreator(){

            public Object createInstance(Object object) {
                final SecureRandom secureRandom = bouncyCastleFipsProvider.getDefaultSecureRandom();
                return new SecureRandomSpi(){

                    protected void engineSetSeed(byte[] byArray) {
                        secureRandom.setSeed(byArray);
                    }

                    protected void engineNextBytes(byte[] byArray) {
                        secureRandom.nextBytes(byArray);
                    }

                    protected byte[] engineGenerateSeed(int n) {
                        return secureRandom.generateSeed(n);
                    }
                };
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecureRandom.NONCEANDIV", "net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.random.NonceAndIVSecureRandom", new EngineCreator(){

            public Object createInstance(Object object) {
                SecureRandom secureRandom = bouncyCastleFipsProvider.getDefaultEntropySource();
                final FipsSecureRandom fipsSecureRandom = bouncyCastleFipsProvider.getProviderDefaultRandomBuilder().fromEntropySource(secureRandom, true).setPersonalizationString(ProvRandom.this.generatePersonalizationString()).build(secureRandom.generateSeed(bouncyCastleFipsProvider.getProviderDefaultSecurityStrength() / 16 + 1), false, Strings.toByteArray("Bouncy Castle FIPS Provider Nonce/IV"));
                return new SecureRandomSpi(){

                    protected void engineSetSeed(byte[] byArray) {
                        fipsSecureRandom.setSeed(byArray);
                    }

                    protected void engineNextBytes(byte[] byArray) {
                        fipsSecureRandom.nextBytes(byArray);
                    }

                    protected byte[] engineGenerateSeed(int n) {
                        return fipsSecureRandom.generateSeed(n);
                    }
                };
            }
        });
    }

    private byte[] generatePersonalizationString() {
        return Arrays.concatenate(Strings.toByteArray("NonceAndIV"), Pack.longToLittleEndian(Thread.currentThread().getId()), Pack.longToLittleEndian(System.currentTimeMillis()));
    }
}

