/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertStoreParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.CertStoreCollectionSpi;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.EngineCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.PKIXCertPathBuilderSpi;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.PKIXCertPathValidatorSpi;

class ProvPKIX
extends AsymmetricAlgorithmProvider {
    ProvPKIX() {
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("CertPathValidator.PKIX", "net.snowflake.client.jdbc.internal.org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi", new EngineCreator(){

            public Object createInstance(Object object) {
                return new PKIXCertPathValidatorSpi(bouncyCastleFipsProvider);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("CertPathBuilder.PKIX", "net.snowflake.client.jdbc.internal.org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi", new EngineCreator(){

            public Object createInstance(Object object) {
                return new PKIXCertPathBuilderSpi(bouncyCastleFipsProvider);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("CertStore.COLLECTION", "net.snowflake.client.jdbc.internal.org.bouncycastle.jce.provider.CertStoreCollectionSpi", new EngineCreator(){

            public Object createInstance(Object object) throws NoSuchAlgorithmException {
                try {
                    return new CertStoreCollectionSpi((CertStoreParameters)object);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new NoSuchAlgorithmException("Unable to construct CertStore implementation: " + invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
                }
            }
        });
    }
}

