/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricPrivateKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricPublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.DigestAlgorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.OutputSignerUsingSecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.OutputVerifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricGOST3410PrivateKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricGOST3410PublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.GOST3410DomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.GOST3410Parameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.DSAOutputSigner;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.DSAOutputVerifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GeneralAlgorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GeneralParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Gost3410KeyGenerationParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Gost3410KeyPairGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Gost3410Parameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Gost3410PrivateKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Gost3410PublicKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Gost3410Signer;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GuardedAsymmetricKeyPairGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GuardedSignatureOperatorFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Register;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.SecureHash;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.SelfTestExecutor;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Utils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.DSA;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.Digest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.test.ConsistencyTest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.encoders.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GOST3410 {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("GOST3410", (Enum)Variations.GOST3410);
    public static final SignatureParameters GOST3410 = new SignatureParameters();

    private GOST3410() {
    }

    private static Gost3410Parameters getDomainParams(GOST3410Parameters<GOST3410DomainParameters> gOST3410Parameters) {
        GOST3410DomainParameters gOST3410DomainParameters = gOST3410Parameters.getDomainParameters();
        return new Gost3410Parameters(gOST3410DomainParameters.getP(), gOST3410DomainParameters.getQ(), gOST3410DomainParameters.getA());
    }

    private static void validateKeyPair(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        SelfTestExecutor.validate((Algorithm)ALGORITHM, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

            @Override
            public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
                byte[] byArray = Hex.decode("576a1f885e3420128c8a656097ba7d8bb4c6f1b1853348cf2ba976971dbdbefc");
                Gost3410Signer gost3410Signer = new Gost3410Signer();
                gost3410Signer.init(true, new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), Utils.testRandom));
                BigInteger[] bigIntegerArray = gost3410Signer.generateSignature(byArray);
                gost3410Signer.init(false, asymmetricCipherKeyPair.getPublic());
                gost3410Signer.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1]);
                return gost3410Signer.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1]);
            }
        });
    }

    private static Gost3410PrivateKeyParameters getLwKey(final AsymmetricGOST3410PrivateKey asymmetricGOST3410PrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<Gost3410PrivateKeyParameters>(){

            @Override
            public Gost3410PrivateKeyParameters run() {
                return new Gost3410PrivateKeyParameters(asymmetricGOST3410PrivateKey.getX(), net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GOST3410.getDomainParams(asymmetricGOST3410PrivateKey.getParameters()));
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyGenParameters
    extends GeneralParameters {
        private final GOST3410Parameters<GOST3410DomainParameters> domainParameters;

        public KeyGenParameters(GOST3410Parameters<GOST3410DomainParameters> gOST3410Parameters) {
            super(ALGORITHM);
            this.domainParameters = gOST3410Parameters;
        }

        public GOST3410Parameters<GOST3410DomainParameters> getDomainParameters() {
            return this.domainParameters;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricGOST3410PublicKey, AsymmetricGOST3410PrivateKey> {
        private final Gost3410KeyPairGenerator engine = new Gost3410KeyPairGenerator();
        private final GOST3410Parameters<GOST3410DomainParameters> parameters;
        private final Gost3410KeyGenerationParameters param;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom secureRandom) {
            super(keyGenParameters);
            this.parameters = keyGenParameters.getDomainParameters();
            this.param = new Gost3410KeyGenerationParameters(secureRandom, net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GOST3410.getDomainParams(this.parameters));
            this.engine.init(this.param);
        }

        @Override
        protected AsymmetricKeyPair<AsymmetricGOST3410PublicKey, AsymmetricGOST3410PrivateKey> doGenerateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GOST3410.validateKeyPair(asymmetricCipherKeyPair);
            Gost3410PublicKeyParameters gost3410PublicKeyParameters = (Gost3410PublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            Gost3410PrivateKeyParameters gost3410PrivateKeyParameters = (Gost3410PrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            Object t = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            return new AsymmetricKeyPair<AsymmetricGOST3410PublicKey, AsymmetricGOST3410PrivateKey>(new AsymmetricGOST3410PublicKey((Algorithm)t, this.parameters, gost3410PublicKeyParameters.getY()), new AsymmetricGOST3410PrivateKey((Algorithm)t, this.parameters, gost3410PrivateKeyParameters.getX()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SignatureOperatorFactory
    extends GuardedSignatureOperatorFactory<SignatureParameters> {
        @Override
        public OutputSignerUsingSecureRandom<SignatureParameters> doCreateSigner(AsymmetricPrivateKey asymmetricPrivateKey, SignatureParameters signatureParameters) {
            Gost3410Signer gost3410Signer = new Gost3410Signer();
            Digest digest = Register.createDigest(signatureParameters.getDigestAlgorithm());
            AsymmetricGOST3410PrivateKey asymmetricGOST3410PrivateKey = (AsymmetricGOST3410PrivateKey)asymmetricPrivateKey;
            final Gost3410PrivateKeyParameters gost3410PrivateKeyParameters = net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GOST3410.getLwKey(asymmetricGOST3410PrivateKey);
            return new DSAOutputSigner<SignatureParameters>(gost3410Signer, digest, signatureParameters, new DSAOutputSigner.Initializer(){

                public void initialize(DSA dSA, SecureRandom secureRandom) {
                    dSA.init(true, new ParametersWithRandom(gost3410PrivateKeyParameters, secureRandom));
                }
            });
        }

        @Override
        public OutputVerifier<SignatureParameters> doCreateVerifier(AsymmetricPublicKey asymmetricPublicKey, SignatureParameters signatureParameters) {
            Gost3410Signer gost3410Signer = new Gost3410Signer();
            Digest digest = Register.createDigest(signatureParameters.getDigestAlgorithm());
            AsymmetricGOST3410PublicKey asymmetricGOST3410PublicKey = (AsymmetricGOST3410PublicKey)asymmetricPublicKey;
            Gost3410PublicKeyParameters gost3410PublicKeyParameters = new Gost3410PublicKeyParameters(asymmetricGOST3410PublicKey.getY(), net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GOST3410.getDomainParams(asymmetricGOST3410PublicKey.getParameters()));
            gost3410Signer.init(false, gost3410PublicKeyParameters);
            return new DSAOutputVerifier<SignatureParameters>(gost3410Signer, digest, signatureParameters);
        }
    }

    public static final class SignatureParameters
    extends GeneralParameters {
        private final DigestAlgorithm digestAlgorithm;

        SignatureParameters() {
            this(SecureHash.Algorithm.GOST3411);
        }

        private SignatureParameters(DigestAlgorithm digestAlgorithm) {
            super(ALGORITHM);
            this.digestAlgorithm = digestAlgorithm;
        }

        public DigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public SignatureParameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new SignatureParameters(digestAlgorithm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Variations {
        GOST3410;

    }
}

