/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.DigestAlgorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.InvalidCipherTextException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.InvalidWrappingException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.KeyUnwrapperUsingSecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.KeyWrapperUsingSecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.PlainInputProcessingException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.SingleBlockDecryptor;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricDHKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricDHPrivateKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricDHPublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.DHDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsDH;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsSHS;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsStatus;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.ElGamalEngine;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.ElGamalParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.ElGamalPrivateKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.ElGamalPublicKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GeneralAlgorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GeneralParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GuardedAsymmetricKeyPairGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GuardedAsymmetricOperatorFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Register;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Utils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.AsymmetricBlockCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.CipherParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.encodings.OAEPEncoding;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.encodings.PKCS1Encoding;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Arrays;

public final class ElGamal {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("ELGAMAL", (Enum)Variations.RAW);
    private static final GeneralAlgorithm PKCS1v1_5 = new GeneralAlgorithm("ELGAMAL/PKCS1V1.5", (Enum)Variations.PKCS1v1_5);
    private static final GeneralAlgorithm ALGORITHM_OAEP = new GeneralAlgorithm("ELGAMAL/OAEP", (Enum)Variations.OAEP);
    public static final RawParameters RAW = new RawParameters();
    public static final OAEPParameters WRAP_OAEP = new OAEPParameters();
    public static final PKCS1v15Parameters WRAP_PKCS1v1_5 = new PKCS1v15Parameters();

    private ElGamal() {
    }

    private static AsymmetricBlockCipher createCipher(boolean bl, AsymmetricKey asymmetricKey, Parameters parameters, SecureRandom secureRandom) {
        CipherParameters cipherParameters;
        Object object;
        AsymmetricBlockCipher asymmetricBlockCipher = new ElGamalEngine();
        if (asymmetricKey instanceof AsymmetricDHPublicKey) {
            object = (AsymmetricDHPublicKey)asymmetricKey;
            cipherParameters = new ElGamalPublicKeyParameters(((AsymmetricDHPublicKey)object).getY(), new ElGamalParameters(((AsymmetricDHKey)object).getDomainParameters().getP(), ((AsymmetricDHKey)object).getDomainParameters().getG(), ((AsymmetricDHKey)object).getDomainParameters().getL()));
        } else {
            object = (AsymmetricDHPrivateKey)asymmetricKey;
            cipherParameters = new ElGamalPrivateKeyParameters(((AsymmetricDHPrivateKey)object).getX(), new ElGamalParameters(((AsymmetricDHKey)object).getDomainParameters().getP(), ((AsymmetricDHKey)object).getDomainParameters().getG(), ((AsymmetricDHKey)object).getDomainParameters().getL()));
        }
        if (parameters.getAlgorithm().equals(PKCS1v1_5)) {
            asymmetricBlockCipher = new PKCS1Encoding(asymmetricBlockCipher);
        } else if (parameters.getAlgorithm().equals(ALGORITHM_OAEP)) {
            object = (OAEPParameters)parameters;
            asymmetricBlockCipher = new OAEPEncoding(asymmetricBlockCipher, Register.createDigest(((OAEPParameters)object).digestAlgorithm), Register.createDigest(((OAEPParameters)object).mgfDigestAlgorithm), ((OAEPParameters)object).encodingParams);
        }
        if (secureRandom != null) {
            cipherParameters = new ParametersWithRandom(cipherParameters, secureRandom);
        }
        asymmetricBlockCipher.init(bl, cipherParameters);
        return asymmetricBlockCipher;
    }

    public static final class KeyGenParameters
    extends GeneralParameters {
        private DHDomainParameters domainParameters;

        public KeyGenParameters(DHDomainParameters dHDomainParameters) {
            super(ALGORITHM);
            this.domainParameters = dHDomainParameters;
        }

        public KeyGenParameters(Parameters parameters, DHDomainParameters dHDomainParameters) {
            super(parameters.getAlgorithm());
            this.domainParameters = dHDomainParameters;
        }

        public DHDomainParameters getDomainParameters() {
            return this.domainParameters;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricDHPublicKey, AsymmetricDHPrivateKey> {
        private final FipsDH.KeyPairGenerator kpGen;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom secureRandom) {
            super(keyGenParameters);
            this.kpGen = new FipsDH.KeyPairGenerator(new FipsDH.KeyGenParameters(keyGenParameters.domainParameters), secureRandom);
        }

        @Override
        protected AsymmetricKeyPair<AsymmetricDHPublicKey, AsymmetricDHPrivateKey> doGenerateKeyPair() {
            AsymmetricKeyPair<AsymmetricDHPublicKey, AsymmetricDHPrivateKey> asymmetricKeyPair = this.kpGen.generateKeyPair();
            Object t = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            AsymmetricDHPublicKey asymmetricDHPublicKey = asymmetricKeyPair.getPublicKey();
            AsymmetricDHPrivateKey asymmetricDHPrivateKey = asymmetricKeyPair.getPrivateKey();
            return new AsymmetricKeyPair<AsymmetricDHPublicKey, AsymmetricDHPrivateKey>(new AsymmetricDHPublicKey((Algorithm)t, asymmetricDHPublicKey.getDomainParameters(), asymmetricDHPublicKey.getY()), new AsymmetricDHPrivateKey((Algorithm)t, asymmetricDHPrivateKey.getDomainParameters(), asymmetricDHPrivateKey.getX()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyWrapOperatorFactory
    implements net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.KeyWrapOperatorFactory<WrapParameters, AsymmetricDHKey> {
        public KeyWrapOperatorFactory() {
            FipsStatus.isReady();
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode");
            }
        }

        @Override
        public KeyWrapperUsingSecureRandom<WrapParameters> createKeyWrapper(AsymmetricDHKey asymmetricDHKey, WrapParameters wrapParameters) {
            return new KeyWrapper(asymmetricDHKey, wrapParameters, null);
        }

        @Override
        public KeyUnwrapperUsingSecureRandom<WrapParameters> createKeyUnwrapper(AsymmetricDHKey asymmetricDHKey, WrapParameters wrapParameters) {
            return new KeyUnwrapper(asymmetricDHKey, wrapParameters, null);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class KeyUnwrapper
        implements KeyUnwrapperUsingSecureRandom<WrapParameters> {
            private final AsymmetricBlockCipher keyWrapper;
            private final AsymmetricDHKey key;
            private final WrapParameters parameters;

            public KeyUnwrapper(AsymmetricDHKey asymmetricDHKey, WrapParameters wrapParameters, SecureRandom secureRandom) {
                if (!(wrapParameters instanceof Parameters)) {
                    throw new IllegalArgumentException("Unknown parameters object: " + wrapParameters.getClass().getName());
                }
                this.key = asymmetricDHKey;
                this.parameters = wrapParameters;
                this.keyWrapper = secureRandom != null ? ElGamal.createCipher(false, asymmetricDHKey, (Parameters)((Object)wrapParameters), secureRandom) : null;
            }

            @Override
            public WrapParameters getParameters() {
                return this.parameters;
            }

            @Override
            public byte[] unwrap(byte[] byArray, int n, int n2) throws InvalidWrappingException {
                if (this.keyWrapper == null) {
                    throw new IllegalStateException("KeyUnwrapper requires a SecureRandom");
                }
                Utils.approveModeCheck(this.parameters.getAlgorithm());
                try {
                    return this.keyWrapper.processBlock(byArray, n, n2);
                }
                catch (Exception exception) {
                    throw new InvalidWrappingException("Unable to unwrap key: " + exception.getMessage(), exception);
                }
            }

            @Override
            public KeyUnwrapperUsingSecureRandom<WrapParameters> withSecureRandom(SecureRandom secureRandom) {
                return new KeyUnwrapper(this.key, this.parameters, secureRandom);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class KeyWrapper
        implements KeyWrapperUsingSecureRandom<WrapParameters> {
            private final AsymmetricBlockCipher keyWrapper;
            private final AsymmetricDHKey key;
            private final WrapParameters parameters;

            public KeyWrapper(AsymmetricDHKey asymmetricDHKey, WrapParameters wrapParameters, SecureRandom secureRandom) {
                if (!(wrapParameters instanceof Parameters)) {
                    throw new IllegalArgumentException("Unknown parameters object: " + wrapParameters.getClass().getName());
                }
                this.key = asymmetricDHKey;
                this.parameters = wrapParameters;
                this.keyWrapper = secureRandom != null ? ElGamal.createCipher(true, asymmetricDHKey, (Parameters)((Object)wrapParameters), secureRandom) : null;
            }

            @Override
            public WrapParameters getParameters() {
                return this.parameters;
            }

            @Override
            public byte[] wrap(byte[] byArray, int n, int n2) throws PlainInputProcessingException {
                if (this.keyWrapper == null) {
                    throw new IllegalStateException("KeyWrapper requires a SecureRandom");
                }
                Utils.approveModeCheck(this.parameters.getAlgorithm());
                try {
                    return this.keyWrapper.processBlock(byArray, n, n2);
                }
                catch (Exception exception) {
                    throw new PlainInputProcessingException("Unable to wrap key: " + exception.getMessage(), exception);
                }
            }

            @Override
            public KeyWrapperUsingSecureRandom<WrapParameters> withSecureRandom(SecureRandom secureRandom) {
                return new KeyWrapper(this.key, this.parameters, secureRandom);
            }
        }
    }

    public static final class OAEPParameters
    extends Parameters
    implements WrapParameters {
        private final DigestAlgorithm digestAlgorithm;
        private final DigestAlgorithm mgfDigestAlgorithm;
        private final byte[] encodingParams;

        OAEPParameters() {
            this(FipsSHS.Algorithm.SHA1, FipsSHS.Algorithm.SHA1, null);
        }

        private OAEPParameters(DigestAlgorithm digestAlgorithm, DigestAlgorithm digestAlgorithm2, byte[] byArray) {
            super(ALGORITHM_OAEP);
            this.digestAlgorithm = digestAlgorithm;
            this.mgfDigestAlgorithm = digestAlgorithm2;
            this.encodingParams = Arrays.clone(byArray);
        }

        public OAEPParameters withDigest(DigestAlgorithm digestAlgorithm) {
            return new OAEPParameters(digestAlgorithm, digestAlgorithm, this.encodingParams);
        }

        public OAEPParameters withMGFDigest(DigestAlgorithm digestAlgorithm) {
            return new OAEPParameters(this.digestAlgorithm, digestAlgorithm, this.encodingParams);
        }

        public OAEPParameters withEncodingParams(byte[] byArray) {
            return new OAEPParameters(this.digestAlgorithm, this.mgfDigestAlgorithm, Arrays.clone(byArray));
        }

        public DigestAlgorithm getDigest() {
            return this.digestAlgorithm;
        }

        public DigestAlgorithm getMGFDigest() {
            return this.mgfDigestAlgorithm;
        }

        public byte[] getEncodingParams() {
            return Arrays.clone(this.encodingParams);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory
    extends GuardedAsymmetricOperatorFactory<Parameters> {
        @Override
        public SingleBlockDecryptor<Parameters> createBlockDecryptor(AsymmetricKey asymmetricKey, final Parameters parameters) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", (Algorithm)parameters.getAlgorithm());
            }
            final AsymmetricBlockCipher asymmetricBlockCipher = this.createCipher(false, asymmetricKey, parameters, (SecureRandom)null);
            return new SingleBlockDecryptor<Parameters>(){

                @Override
                public byte[] decryptBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
                    try {
                        Utils.approveModeCheck(parameters.getAlgorithm());
                        return asymmetricBlockCipher.processBlock(byArray, n, n2);
                    }
                    catch (net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.InvalidCipherTextException invalidCipherTextException) {
                        throw new InvalidCipherTextException(invalidCipherTextException.getMessage(), invalidCipherTextException);
                    }
                }

                @Override
                public Parameters getParameters() {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return parameters;
                }

                @Override
                public int getInputSize() {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    if (GuardedAsymmetricOperatorFactory.isRawEngine(asymmetricBlockCipher)) {
                        return asymmetricBlockCipher.getInputBlockSize() + 1;
                    }
                    return asymmetricBlockCipher.getInputBlockSize();
                }

                @Override
                public int getOutputSize() {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return asymmetricBlockCipher.getOutputBlockSize();
                }
            };
        }

        @Override
        protected AsymmetricBlockCipher createCipher(boolean bl, AsymmetricKey asymmetricKey, Parameters parameters, SecureRandom secureRandom) {
            return ElGamal.createCipher(bl, asymmetricKey, parameters, secureRandom);
        }
    }

    public static final class PKCS1v15Parameters
    extends Parameters
    implements WrapParameters {
        PKCS1v15Parameters() {
            super(PKCS1v1_5);
        }
    }

    public static class Parameters
    extends GeneralParameters {
        Parameters(GeneralAlgorithm generalAlgorithm) {
            super(generalAlgorithm);
        }
    }

    public static final class RawParameters
    extends Parameters {
        RawParameters() {
            super(ALGORITHM);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Variations {
        RAW,
        PKCS1v1_5,
        OAEP;

    }

    public static interface WrapParameters
    extends net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Parameters {
    }
}

