/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricPublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricECKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricECPublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.EcMqvBasicAgreement;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsAgreement;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsAgreementParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsEC;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsKDF;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.BasicAgreement;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.EcDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.EcMqvPublicParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.EcNamedDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.BigIntegers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EcDHAgreement<T extends FipsAgreementParameters>
extends FipsAgreement<T> {
    private final BasicAgreement dh;
    private final T parameter;

    EcDHAgreement(BasicAgreement basicAgreement, T t) {
        this.dh = basicAgreement;
        this.parameter = t;
    }

    @Override
    public T getParameters() {
        return this.parameter;
    }

    @Override
    public byte[] calculate(AsymmetricPublicKey asymmetricPublicKey) {
        BigInteger bigInteger;
        Object object;
        AsymmetricECPublicKey asymmetricECPublicKey = (AsymmetricECPublicKey)asymmetricPublicKey;
        EcPublicKeyParameters ecPublicKeyParameters = new EcPublicKeyParameters(asymmetricECPublicKey.getW(), EcDHAgreement.getDomainParams(asymmetricECPublicKey.getDomainParameters()));
        int n = this.dh.getFieldSize();
        if (this.dh instanceof EcMqvBasicAgreement) {
            object = ((FipsEC.MQVAgreementParameters)this.parameter).getOtherPartyEphemeralKey();
            bigInteger = this.dh.calculateAgreement(new EcMqvPublicParameters(ecPublicKeyParameters, new EcPublicKeyParameters(((AsymmetricECPublicKey)object).getW(), EcDHAgreement.getDomainParams(((AsymmetricECKey)object).getDomainParameters()))));
        } else {
            bigInteger = this.dh.calculateAgreement(ecPublicKeyParameters);
        }
        object = BigIntegers.asUnsignedByteArray(n, bigInteger);
        return FipsKDF.processZBytes((byte[])object, this.parameter);
    }

    private static EcDomainParameters getDomainParams(ECDomainParameters eCDomainParameters) {
        if (eCDomainParameters instanceof NamedECDomainParameters) {
            return new EcNamedDomainParameters(((NamedECDomainParameters)eCDomainParameters).getID(), eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
        }
        return new EcDomainParameters(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
    }
}

