/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.DhParametersHelper;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.DhParameters;

class DhParametersGenerator {
    private int size;
    private int certainty;
    private SecureRandom random;
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    DhParametersGenerator() {
    }

    public void init(int n, int n2, SecureRandom secureRandom) {
        this.size = n;
        this.certainty = n2;
        this.random = secureRandom;
    }

    public DhParameters generateParameters() {
        BigInteger[] bigIntegerArray = DhParametersHelper.generateSafePrimes(this.size, this.certainty, this.random);
        BigInteger bigInteger = bigIntegerArray[0];
        BigInteger bigInteger2 = bigIntegerArray[1];
        BigInteger bigInteger3 = DhParametersHelper.selectGenerator(bigInteger, bigInteger2, this.random);
        return new DhParameters(bigInteger, bigInteger3, bigInteger2, TWO);
    }
}

