/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric;

import java.math.BigInteger;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x9.X962Parameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x9.X9ECParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.CustomNamedCurves;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.ECImplicitDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECCurve;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECPoint;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Arrays;

public class ECDomainParameters {
    private final ECCurve curve;
    private final byte[] seed;
    private final ECPoint G;
    private final BigInteger n;
    private final BigInteger h;

    public ECDomainParameters(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger) {
        this(eCCurve, eCPoint, bigInteger, BigInteger.ONE, null);
    }

    public ECDomainParameters(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2) {
        this(eCCurve, eCPoint, bigInteger, bigInteger2, null);
    }

    public ECDomainParameters(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray) {
        this.curve = eCCurve;
        this.G = eCPoint.normalize();
        this.n = bigInteger;
        this.h = bigInteger2;
        this.seed = Arrays.clone(byArray);
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public ECPoint getG() {
        return this.G;
    }

    public BigInteger getN() {
        return this.n;
    }

    public BigInteger getH() {
        return this.h;
    }

    public byte[] getSeed() {
        return Arrays.clone(this.seed);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ECDomainParameters)) {
            return false;
        }
        ECDomainParameters eCDomainParameters = (ECDomainParameters)object;
        if (!this.G.equals(eCDomainParameters.G)) {
            return false;
        }
        if (!this.curve.equals(eCDomainParameters.curve)) {
            return false;
        }
        if (!this.h.equals(eCDomainParameters.h)) {
            return false;
        }
        return this.n.equals(eCDomainParameters.n);
    }

    public int hashCode() {
        int n = this.curve.hashCode();
        n = 31 * n + this.G.hashCode();
        n = 31 * n + this.n.hashCode();
        n = 31 * n + this.h.hashCode();
        return n;
    }

    static ECDomainParameters decodeCurveParameters(AlgorithmIdentifier algorithmIdentifier) {
        if (!algorithmIdentifier.getAlgorithm().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            throw new IllegalArgumentException("Unknown algorithm type: " + algorithmIdentifier.getAlgorithm());
        }
        X962Parameters x962Parameters = X962Parameters.getInstance(algorithmIdentifier.getParameters());
        if (x962Parameters.isNamedCurve()) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)x962Parameters.getParameters();
            X9ECParameters x9ECParameters = CustomNamedCurves.getByOID(aSN1ObjectIdentifier);
            if (x9ECParameters == null) {
                x9ECParameters = ECNamedCurveTable.getByOID(aSN1ObjectIdentifier);
            }
            return new NamedECDomainParameters(aSN1ObjectIdentifier, x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
        }
        if (!x962Parameters.isImplicitlyCA()) {
            X9ECParameters x9ECParameters = X9ECParameters.getInstance(x962Parameters.getParameters());
            return new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
        }
        return new ECImplicitDomainParameters((ECDomainParameters)CryptoServicesRegistrar.getProperty(CryptoServicesRegistrar.Property.EC_IMPLICITLY_CA));
    }
}

