/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.math.BigInteger;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Integer;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.DSAParameter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricPrivateKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricDSAKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.DSADomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.KeyUtils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.Permissions;

public final class AsymmetricDSAPrivateKey
extends AsymmetricDSAKey
implements AsymmetricPrivateKey {
    private final int hashCode;
    private BigInteger x;

    public AsymmetricDSAPrivateKey(Algorithm algorithm, DSADomainParameters dSADomainParameters, BigInteger bigInteger) {
        super(algorithm, dSADomainParameters);
        this.x = bigInteger;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricDSAPrivateKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, PrivateKeyInfo.getInstance(byArray));
    }

    public AsymmetricDSAPrivateKey(Algorithm algorithm, PrivateKeyInfo privateKeyInfo) {
        super(algorithm, privateKeyInfo.getPrivateKeyAlgorithm());
        this.x = AsymmetricDSAPrivateKey.parsePrivateKey(privateKeyInfo);
        this.hashCode = this.calculateHashCode();
    }

    private static BigInteger parsePrivateKey(PrivateKeyInfo privateKeyInfo) {
        try {
            return ASN1Integer.getInstance(privateKeyInfo.parsePrivateKey()).getValue();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unable to parse DSA private key: " + iOException.getMessage(), iOException);
        }
    }

    public final byte[] getEncoded() {
        DSADomainParameters dSADomainParameters = this.getDomainParameters();
        return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, new DSAParameter(dSADomainParameters.getP(), dSADomainParameters.getQ(), dSADomainParameters.getG())), new ASN1Integer(this.getX()));
    }

    public BigInteger getX() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        return this.x;
    }

    private void zeroize() {
        this.x = null;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n = this.x.hashCode();
        n = 31 * n + this.getDomainParameters().hashCode();
        return n;
    }

    protected void finalize() throws Throwable {
        this.zeroize();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricDSAPrivateKey)) {
            return false;
        }
        AsymmetricDSAPrivateKey asymmetricDSAPrivateKey = (AsymmetricDSAPrivateKey)object;
        return this.x.equals(asymmetricDSAPrivateKey.x) && this.getDomainParameters().equals(asymmetricDSAPrivateKey.getDomainParameters());
    }
}

