/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.cms.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.PrivateKey;
import javax.crypto.Mac;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.KeyTransRecipientId;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.RecipientOperator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.jcajce.JceKTSKeyTransRecipient;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.io.MacOutputStream;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.GenericKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.MacCalculator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.jcajce.JceGenericKey;

public class JceKTSKeyTransAuthenticatedRecipient
extends JceKTSKeyTransRecipient {
    public JceKTSKeyTransAuthenticatedRecipient(PrivateKey recipientKey, KeyTransRecipientId recipientId) throws IOException {
        super(recipientKey, JceKTSKeyTransAuthenticatedRecipient.getPartyVInfoFromRID(recipientId));
    }

    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentMacAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        final Key secretKey = this.extractSecretKey(keyEncryptionAlgorithm, contentMacAlgorithm, encryptedContentEncryptionKey);
        final Mac dataMac = this.contentHelper.createContentMac(secretKey, contentMacAlgorithm);
        return new RecipientOperator(new MacCalculator(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentMacAlgorithm;
            }

            public GenericKey getKey() {
                return new JceGenericKey(contentMacAlgorithm, secretKey);
            }

            public OutputStream getOutputStream() {
                return new MacOutputStream(dataMac);
            }

            public byte[] getMac() {
                return dataMac.doFinal();
            }
        });
    }
}

