/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.cert.cmp;

import java.math.BigInteger;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cmp.CertStatus;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cmp.PKIStatusInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.X509CertificateHolder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.cmp.CMPException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.cmp.CMPUtil;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.DigestCalculator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.DigestCalculatorProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.OperatorCreationException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Arrays;

public class CertificateStatus {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private CertStatus certStatus;

    CertificateStatus(DigestAlgorithmIdentifierFinder digestAlgFinder, CertStatus certStatus) {
        this.digestAlgFinder = digestAlgFinder;
        this.certStatus = certStatus;
    }

    public PKIStatusInfo getStatusInfo() {
        return this.certStatus.getStatusInfo();
    }

    public BigInteger getCertRequestID() {
        return this.certStatus.getCertReqId().getValue();
    }

    public boolean isVerified(X509CertificateHolder certHolder, DigestCalculatorProvider digesterProvider) throws CMPException {
        DigestCalculator digester;
        AlgorithmIdentifier digAlg = this.digestAlgFinder.find(certHolder.toASN1Structure().getSignatureAlgorithm());
        if (digAlg == null) {
            throw new CMPException("cannot find algorithm for digest from signature");
        }
        try {
            digester = digesterProvider.get(digAlg);
        }
        catch (OperatorCreationException e) {
            throw new CMPException("unable to create digester: " + e.getMessage(), e);
        }
        CMPUtil.derEncodeToStream(certHolder.toASN1Structure(), digester.getOutputStream());
        return Arrays.areEqual(this.certStatus.getCertHash().getOctets(), digester.getDigest());
    }
}

