/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.snowflake.client.jdbc.internal.apache.arrow.util.Preconditions;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BufferLayout;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.ArrowType;

public class TypeLayout {
    private final List<BufferLayout> bufferLayouts;

    public static TypeLayout getTypeLayout(ArrowType arrowType) {
        TypeLayout layout = arrowType.accept(new ArrowType.ArrowTypeVisitor<TypeLayout>(){

            @Override
            public TypeLayout visit(ArrowType.Int type) {
                return this.newFixedWidthTypeLayout(BufferLayout.dataBuffer(type.getBitWidth()));
            }

            @Override
            public TypeLayout visit(ArrowType.Union type) {
                List<BufferLayout> vectors;
                switch (type.getMode()) {
                    case Dense: {
                        vectors = Arrays.asList(BufferLayout.validityVector(), BufferLayout.typeBuffer(), BufferLayout.offsetBuffer());
                        break;
                    }
                    case Sparse: {
                        vectors = Arrays.asList(BufferLayout.typeBuffer());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported Union Mode: " + (Object)((Object)type.getMode()));
                    }
                }
                return new TypeLayout(vectors);
            }

            @Override
            public TypeLayout visit(ArrowType.Struct type) {
                List<BufferLayout> vectors = Arrays.asList(BufferLayout.validityVector());
                return new TypeLayout(vectors);
            }

            @Override
            public TypeLayout visit(ArrowType.Timestamp type) {
                return this.newFixedWidthTypeLayout(BufferLayout.dataBuffer(64));
            }

            @Override
            public TypeLayout visit(ArrowType.List type) {
                List<BufferLayout> vectors = Arrays.asList(BufferLayout.validityVector(), BufferLayout.offsetBuffer());
                return new TypeLayout(vectors);
            }

            @Override
            public TypeLayout visit(ArrowType.FixedSizeList type) {
                List<BufferLayout> vectors = Arrays.asList(BufferLayout.validityVector());
                return new TypeLayout(vectors);
            }

            @Override
            public TypeLayout visit(ArrowType.FloatingPoint type) {
                int bitWidth;
                switch (type.getPrecision()) {
                    case HALF: {
                        bitWidth = 16;
                        break;
                    }
                    case SINGLE: {
                        bitWidth = 32;
                        break;
                    }
                    case DOUBLE: {
                        bitWidth = 64;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported Precision: " + (Object)((Object)type.getPrecision()));
                    }
                }
                return this.newFixedWidthTypeLayout(BufferLayout.dataBuffer(bitWidth));
            }

            @Override
            public TypeLayout visit(ArrowType.Decimal type) {
                return this.newFixedWidthTypeLayout(BufferLayout.dataBuffer(128));
            }

            @Override
            public TypeLayout visit(ArrowType.FixedSizeBinary type) {
                return this.newFixedWidthTypeLayout(new BufferLayout(BufferLayout.BufferType.DATA, type.getByteWidth() * 8));
            }

            @Override
            public TypeLayout visit(ArrowType.Bool type) {
                return this.newFixedWidthTypeLayout(BufferLayout.booleanVector());
            }

            @Override
            public TypeLayout visit(ArrowType.Binary type) {
                return this.newVariableWidthTypeLayout();
            }

            @Override
            public TypeLayout visit(ArrowType.Utf8 type) {
                return this.newVariableWidthTypeLayout();
            }

            private TypeLayout newVariableWidthTypeLayout() {
                return this.newPrimitiveTypeLayout(BufferLayout.validityVector(), BufferLayout.offsetBuffer(), BufferLayout.byteVector());
            }

            private TypeLayout newPrimitiveTypeLayout(BufferLayout ... vectors) {
                return new TypeLayout(Arrays.asList(vectors));
            }

            public TypeLayout newFixedWidthTypeLayout(BufferLayout dataVector) {
                return this.newPrimitiveTypeLayout(BufferLayout.validityVector(), dataVector);
            }

            @Override
            public TypeLayout visit(ArrowType.Null type) {
                return new TypeLayout(Collections.emptyList());
            }

            @Override
            public TypeLayout visit(ArrowType.Date type) {
                switch (type.getUnit()) {
                    case DAY: {
                        return this.newFixedWidthTypeLayout(BufferLayout.dataBuffer(32));
                    }
                    case MILLISECOND: {
                        return this.newFixedWidthTypeLayout(BufferLayout.dataBuffer(64));
                    }
                }
                throw new UnsupportedOperationException("Unknown unit " + (Object)((Object)type.getUnit()));
            }

            @Override
            public TypeLayout visit(ArrowType.Time type) {
                return this.newFixedWidthTypeLayout(BufferLayout.dataBuffer(type.getBitWidth()));
            }

            @Override
            public TypeLayout visit(ArrowType.Interval type) {
                switch (type.getUnit()) {
                    case DAY_TIME: {
                        return this.newFixedWidthTypeLayout(BufferLayout.dataBuffer(64));
                    }
                    case YEAR_MONTH: {
                        return this.newFixedWidthTypeLayout(BufferLayout.dataBuffer(32));
                    }
                }
                throw new UnsupportedOperationException("Unknown unit " + (Object)((Object)type.getUnit()));
            }
        });
        return layout;
    }

    public TypeLayout(List<BufferLayout> bufferLayouts) {
        this.bufferLayouts = Preconditions.checkNotNull(bufferLayouts);
    }

    public TypeLayout(BufferLayout ... bufferLayouts) {
        this(Arrays.asList(bufferLayouts));
    }

    public List<BufferLayout> getBufferLayouts() {
        return this.bufferLayouts;
    }

    public List<BufferLayout.BufferType> getBufferTypes() {
        ArrayList<BufferLayout.BufferType> types = new ArrayList<BufferLayout.BufferType>(this.bufferLayouts.size());
        for (BufferLayout vector : this.bufferLayouts) {
            types.add(vector.getType());
        }
        return types;
    }

    public String toString() {
        return this.bufferLayouts.toString();
    }

    public int hashCode() {
        return this.bufferLayouts.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeLayout other = (TypeLayout)obj;
        return this.bufferLayouts.equals(other.bufferLayouts);
    }
}

