/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.TimeStampMilliTZReaderImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeStampMilliTZHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.TimeStampMilliTZHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.TimeUnit;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.ArrowType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;

public class TimeStampMilliTZVector
extends TimeStampVector {
    private final FieldReader reader;
    private final String timeZone;

    public TimeStampMilliTZVector(String name, BufferAllocator allocator, String timeZone) {
        this(name, FieldType.nullable(new ArrowType.Timestamp(TimeUnit.MILLISECOND, timeZone)), allocator);
    }

    public TimeStampMilliTZVector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, fieldType, allocator);
        ArrowType.Timestamp arrowType = (ArrowType.Timestamp)fieldType.getType();
        this.timeZone = arrowType.getTimezone();
        this.reader = new TimeStampMilliTZReaderImpl(this);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TIMESTAMPMILLITZ;
    }

    public void get(int index, NullableTimeStampMilliTZHolder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getLong(index * 8);
    }

    @Override
    public Long getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.valueBuffer.getLong(index * 8);
    }

    public void set(int index, NullableTimeStampMilliTZHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void set(int index, TimeStampMilliTZHolder holder) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, NullableTimeStampMilliTZHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, TimeStampMilliTZHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        TimeStampMilliTZVector to = new TimeStampMilliTZVector(ref, this.field.getFieldType(), allocator);
        return new TimeStampVector.TransferImpl(to);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TimeStampVector.TransferImpl((TimeStampMilliTZVector)to);
    }
}

