/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowFieldNode;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public class BitVectorHelper {
    public static int byteIndex(int absoluteBitIndex) {
        return absoluteBitIndex >> 3;
    }

    public static int bitIndex(int absoluteBitIndex) {
        return absoluteBitIndex & 7;
    }

    public static void setValidityBitToOne(ArrowBuf validityBuffer, int index) {
        int byteIndex = BitVectorHelper.byteIndex(index);
        int bitIndex = BitVectorHelper.bitIndex(index);
        byte currentByte = validityBuffer.getByte(byteIndex);
        byte bitMask = (byte)(1L << bitIndex);
        currentByte = (byte)(currentByte | bitMask);
        validityBuffer.setByte(byteIndex, currentByte);
    }

    public static void setValidityBit(ArrowBuf validityBuffer, int index, int value) {
        int byteIndex = BitVectorHelper.byteIndex(index);
        int bitIndex = BitVectorHelper.bitIndex(index);
        byte currentByte = validityBuffer.getByte(byteIndex);
        byte bitMask = (byte)(1L << bitIndex);
        currentByte = value != 0 ? (byte)(currentByte | bitMask) : (byte)(currentByte - (bitMask & currentByte));
        validityBuffer.setByte(byteIndex, currentByte);
    }

    public static ArrowBuf setValidityBit(ArrowBuf validityBuffer, BufferAllocator allocator, int valueCount, int index, int value) {
        if (validityBuffer == null) {
            validityBuffer = allocator.buffer(BitVectorHelper.getValidityBufferSize(valueCount));
        }
        BitVectorHelper.setValidityBit(validityBuffer, index, value);
        if (index == valueCount - 1) {
            validityBuffer.writerIndex(BitVectorHelper.getValidityBufferSize(valueCount));
        }
        return validityBuffer;
    }

    public static int get(ArrowBuf buffer, int index) {
        int byteIndex = index >> 3;
        byte b = buffer.getByte(byteIndex);
        int bitIndex = index & 7;
        return b >> bitIndex & 1;
    }

    public static int getValidityBufferSize(int valueCount) {
        return (int)Math.ceil((double)valueCount / 8.0);
    }

    public static int getNullCount(ArrowBuf validityBuffer, int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        int count = 0;
        int sizeInBytes = BitVectorHelper.getValidityBufferSize(valueCount);
        int remainder = valueCount % 8;
        int sizeInBytesMinus1 = sizeInBytes - 1;
        for (int i = 0; i < sizeInBytesMinus1; ++i) {
            byte byteValue = validityBuffer.getByte(i);
            count += Integer.bitCount(byteValue & 0xFF);
        }
        byte byteValue = validityBuffer.getByte(sizeInBytes - 1);
        if (remainder != 0) {
            byte mask = (byte)(255 << remainder);
            byteValue = (byte)(byteValue | mask);
        }
        return 8 * sizeInBytes - (count += Integer.bitCount(byteValue & 0xFF));
    }

    public static byte getBitsFromCurrentByte(ArrowBuf data, int index, int offset) {
        return (byte)((data.getByte(index) & 0xFF) >>> offset);
    }

    public static byte getBitsFromNextByte(ArrowBuf data, int index, int offset) {
        return (byte)(data.getByte(index) << 8 - offset);
    }

    public static ArrowBuf loadValidityBuffer(ArrowFieldNode fieldNode, ArrowBuf sourceValidityBuffer, BufferAllocator allocator) {
        int valueCount = fieldNode.getLength();
        ArrowBuf newBuffer = null;
        if (fieldNode.getNullCount() == 0 || fieldNode.getNullCount() == valueCount) {
            newBuffer = allocator.buffer(BitVectorHelper.getValidityBufferSize(valueCount));
            newBuffer.setZero(0, newBuffer.capacity());
            if (fieldNode.getNullCount() != 0) {
                return newBuffer;
            }
            int fullBytesCount = valueCount / 8;
            for (int i = 0; i < fullBytesCount; ++i) {
                newBuffer.setByte(i, 255);
            }
            int remainder = valueCount % 8;
            if (remainder > 0) {
                byte bitMask = (byte)(255L >>> (8 - remainder & 7));
                newBuffer.setByte(fullBytesCount, bitMask);
            }
        } else {
            newBuffer = sourceValidityBuffer.retain(allocator);
        }
        return newBuffer;
    }

    static void setBitMaskedByte(ArrowBuf data, int byteIndex, byte bitMask) {
        byte currentByte = data.getByte(byteIndex);
        currentByte = (byte)(currentByte | bitMask);
        data.setByte(byteIndex, currentByte);
    }
}

