/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.util.HashSet;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class HeartbeatBackground
implements Runnable {
    private static HeartbeatBackground singleton = new HeartbeatBackground();
    private static final SFLogger LOGGER = SFLoggerFactory.getLogger(HeartbeatBackground.class);
    private long masterTokenValidityInSecs = 14400L;
    private long heartBeatIntervalInSecs = this.masterTokenValidityInSecs / 4L;
    private ScheduledExecutorService scheduler = null;
    ScheduledFuture<?> heartbeatFuture;
    WeakHashMap<SFSession, Boolean> sessions = new WeakHashMap();
    private long lastHeartbeatStartTimeInSecs = 0L;

    public static HeartbeatBackground getInstance() {
        return singleton;
    }

    private HeartbeatBackground() {
    }

    protected synchronized void addSession(SFSession session, long masterTokenValidityInSecs, int heartbeatFrequencyInSecs) {
        boolean requireReschedule = false;
        long oldHeartBeatIntervalInSecs = this.heartBeatIntervalInSecs;
        this.heartBeatIntervalInSecs = heartbeatFrequencyInSecs;
        if (this.heartBeatIntervalInSecs > masterTokenValidityInSecs / 4L) {
            this.heartBeatIntervalInSecs = masterTokenValidityInSecs / 4L;
        }
        LOGGER.debug("update heartbeat interval from {} to {}", oldHeartBeatIntervalInSecs, this.heartBeatIntervalInSecs);
        requireReschedule = true;
        this.sessions.put(session, Boolean.TRUE);
        if (this.scheduler == null) {
            LOGGER.debug("create heartbeat thread pool");
            this.scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                    thread.setName("heartbeat (" + thread.getId() + ")");
                    thread.setDaemon(true);
                    return thread;
                }
            });
        }
        if (this.heartbeatFuture == null) {
            LOGGER.debug("schedule heartbeat task");
            this.scheduleHeartbeat();
        } else if (requireReschedule) {
            LOGGER.debug("Cancel existing heartbeat task");
            if (this.heartbeatFuture.cancel(false)) {
                LOGGER.debug("Canceled existing heartbeat task, reschedule");
                this.scheduleHeartbeat();
            } else {
                LOGGER.debug("Failed to cancel existing heartbeat task");
            }
        }
    }

    protected synchronized void removeSession(SFSession session) {
        this.sessions.remove(session);
    }

    private void scheduleHeartbeat() {
        long elapsedSecsSinceLastHeartBeat = System.currentTimeMillis() / 1000L - this.lastHeartbeatStartTimeInSecs;
        long initialDelay = Math.max(this.heartBeatIntervalInSecs - elapsedSecsSinceLastHeartBeat, 0L);
        LOGGER.debug("schedule heartbeat task with initial delay of {} seconds", initialDelay);
        this.heartbeatFuture = this.scheduler.schedule(this, initialDelay, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.lastHeartbeatStartTimeInSecs = System.currentTimeMillis() / 1000L;
        HashSet<SFSession> sessionsToHeartbeat = new HashSet<SFSession>();
        Object object = this;
        synchronized (object) {
            sessionsToHeartbeat.addAll(this.sessions.keySet());
        }
        for (SFSession session : sessionsToHeartbeat) {
            try {
                session.heartbeat();
            }
            catch (Throwable ex) {
                LOGGER.error("heartbeat error - message=" + ex.getMessage(), ex);
            }
        }
        object = this;
        synchronized (object) {
            if (this.sessions.size() > 0) {
                LOGGER.debug("schedule next heartbeat run");
                this.scheduleHeartbeat();
            } else {
                LOGGER.debug("no need for heartbeat since no more sessions");
                this.heartbeatFuture = null;
            }
        }
    }
}

