/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.RecordBatch;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowBuffer;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowFieldNode;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowMessage;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.FBSerializables;
import net.snowflake.client.jdbc.internal.google.flatbuffers.FlatBufferBuilder;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrowRecordBatch
implements ArrowMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrowRecordBatch.class);
    private final int length;
    private final List<ArrowFieldNode> nodes;
    private final List<ArrowBuf> buffers;
    private final List<ArrowBuffer> buffersLayout;
    private boolean closed = false;

    public ArrowRecordBatch(int length, List<ArrowFieldNode> nodes, List<ArrowBuf> buffers) {
        this(length, nodes, buffers, true);
    }

    public ArrowRecordBatch(int length, List<ArrowFieldNode> nodes, List<ArrowBuf> buffers, boolean alignBuffers) {
        this.length = length;
        this.nodes = nodes;
        this.buffers = buffers;
        ArrayList<ArrowBuffer> arrowBuffers = new ArrayList<ArrowBuffer>();
        long offset = 0L;
        for (ArrowBuf arrowBuf : buffers) {
            arrowBuf.retain();
            long size = arrowBuf.readableBytes();
            arrowBuffers.add(new ArrowBuffer(offset, size));
            LOGGER.debug("Buffer in RecordBatch at {}, length: {}", (Object)offset, (Object)size);
            if (!alignBuffers || (offset += size) % 8L == 0L) continue;
            offset += 8L - offset % 8L;
        }
        this.buffersLayout = Collections.unmodifiableList(arrowBuffers);
    }

    private ArrowRecordBatch(boolean dummy, int length, List<ArrowFieldNode> nodes, List<ArrowBuf> buffers) {
        this.length = length;
        this.nodes = nodes;
        this.buffers = buffers;
        this.closed = false;
        ArrayList<ArrowBuffer> arrowBuffers = new ArrayList<ArrowBuffer>();
        long offset = 0L;
        for (ArrowBuf arrowBuf : buffers) {
            long size = arrowBuf.readableBytes();
            arrowBuffers.add(new ArrowBuffer(offset, size));
            offset += size;
        }
        this.buffersLayout = Collections.unmodifiableList(arrowBuffers);
    }

    public int getLength() {
        return this.length;
    }

    public List<ArrowFieldNode> getNodes() {
        return this.nodes;
    }

    public List<ArrowBuf> getBuffers() {
        if (this.closed) {
            throw new IllegalStateException("already closed");
        }
        return this.buffers;
    }

    public ArrowRecordBatch cloneWithTransfer(BufferAllocator allocator) {
        List<ArrowBuf> newBufs = this.buffers.stream().map(t -> t.transferOwnership((BufferAllocator)allocator).buffer.writerIndex(t.writerIndex())).collect(Collectors.toList());
        this.close();
        return new ArrowRecordBatch(false, this.length, this.nodes, newBufs);
    }

    public List<ArrowBuffer> getBuffersLayout() {
        return this.buffersLayout;
    }

    @Override
    public int writeTo(FlatBufferBuilder builder) {
        RecordBatch.startNodesVector(builder, this.nodes.size());
        int nodesOffset = FBSerializables.writeAllStructsToVector(builder, this.nodes);
        RecordBatch.startBuffersVector(builder, this.buffers.size());
        int buffersOffset = FBSerializables.writeAllStructsToVector(builder, this.buffersLayout);
        RecordBatch.startRecordBatch(builder);
        RecordBatch.addLength(builder, this.length);
        RecordBatch.addNodes(builder, nodesOffset);
        RecordBatch.addBuffers(builder, buffersOffset);
        return RecordBatch.endRecordBatch(builder);
    }

    @Override
    public <T> T accepts(ArrowMessage.ArrowMessageVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            for (ArrowBuf arrowBuf : this.buffers) {
                arrowBuf.release();
            }
        }
    }

    public String toString() {
        return "ArrowRecordBatch [length=" + this.length + ", nodes=" + this.nodes + ", #buffers=" + this.buffers.size() + ", buffersLayout=" + this.buffersLayout + ", closed=" + this.closed + "]";
    }

    @Override
    public int computeBodyLength() {
        int size = 0;
        List<ArrowBuf> buffers = this.getBuffers();
        List<ArrowBuffer> buffersLayout = this.getBuffersLayout();
        if (buffers.size() != buffersLayout.size()) {
            throw new IllegalStateException("the layout does not match: " + buffers.size() + " != " + buffersLayout.size());
        }
        for (int i = 0; i < buffers.size(); ++i) {
            ArrowBuf buffer = buffers.get(i);
            ArrowBuffer layout = buffersLayout.get(i);
            size = (int)((long)size + (layout.getOffset() - (long)size));
            ByteBuffer nioBuffer = buffer.nioBuffer(buffer.readerIndex(), buffer.readableBytes());
            if ((size += nioBuffer.remaining()) % 8 == 0) continue;
            size += 8 - size % 8;
        }
        return size;
    }
}

