/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.dictionary;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.dictionary.Dictionary;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;

public class DictionaryEncoder {
    public static ValueVector encode(ValueVector vector, Dictionary dictionary) {
        DictionaryEncoder.validateType(vector.getMinorType());
        HashMap<Object, Integer> lookUps = new HashMap<Object, Integer>(dictionary.getVector().getValueCount());
        for (int i = 0; i < dictionary.getVector().getValueCount(); ++i) {
            lookUps.put(dictionary.getVector().getObject(i), i);
        }
        Field valueField = vector.getField();
        FieldType indexFieldType = new FieldType(valueField.isNullable(), dictionary.getEncoding().getIndexType(), dictionary.getEncoding(), valueField.getMetadata());
        Field indexField = new Field(valueField.getName(), indexFieldType, null);
        FieldVector indices = indexField.createVector(vector.getAllocator());
        Method setter = null;
        for (Class c : Arrays.asList(Integer.TYPE, Long.TYPE)) {
            try {
                setter = indices.getClass().getMethod("setSafe", Integer.TYPE, c);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        if (setter == null) {
            throw new IllegalArgumentException("Dictionary encoding does not have a valid int type:" + indices.getClass());
        }
        int count = vector.getValueCount();
        indices.allocateNew();
        try {
            for (int i = 0; i < count; ++i) {
                Object value = vector.getObject(i);
                if (value == null) continue;
                Object encoded = lookUps.get(value);
                if (encoded == null) {
                    throw new IllegalArgumentException("Dictionary encoding not defined for value:" + value);
                }
                setter.invoke((Object)indices, i, encoded);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("IllegalAccessException invoking vector mutator set():", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("InvocationTargetException invoking vector mutator set():", e.getCause());
        }
        indices.setValueCount(count);
        return indices;
    }

    public static ValueVector decode(ValueVector indices, Dictionary dictionary) {
        int count = indices.getValueCount();
        FieldVector dictionaryVector = dictionary.getVector();
        int dictionaryCount = dictionaryVector.getValueCount();
        TransferPair transfer = dictionaryVector.getTransferPair(indices.getAllocator());
        transfer.getTo().allocateNewSafe();
        for (int i = 0; i < count; ++i) {
            Object index = indices.getObject(i);
            if (index == null) continue;
            int indexAsInt = ((Number)index).intValue();
            if (indexAsInt > dictionaryCount) {
                throw new IllegalArgumentException("Provided dictionary does not contain value for index " + indexAsInt);
            }
            transfer.copyValueSafe(indexAsInt, i);
        }
        ValueVector decoded = transfer.getTo();
        decoded.setValueCount(count);
        return decoded;
    }

    private static void validateType(Types.MinorType type) {
        if (type == Types.MinorType.VARBINARY || type == Types.MinorType.FIXEDSIZEBINARY || type == Types.MinorType.LIST || type == Types.MinorType.STRUCT || type == Types.MinorType.UNION) {
            throw new IllegalArgumentException("Dictionary encoding for complex types not implemented: type " + (Object)((Object)type));
        }
    }
}

