/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseFixedWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.UInt2ReaderImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableUInt2Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.UInt2Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;

public class UInt2Vector
extends BaseFixedWidthVector {
    private static final byte TYPE_WIDTH = 2;
    private final FieldReader reader = new UInt2ReaderImpl(this);

    public UInt2Vector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.UINT2.getType()), allocator);
    }

    public UInt2Vector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, allocator, fieldType, 2);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.UINT2;
    }

    public char get(int index) throws IllegalStateException {
        if (this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.getChar(index * 2);
    }

    public void get(int index, NullableUInt2Holder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getChar(index * 2);
    }

    @Override
    public Character getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return Character.valueOf(this.valueBuffer.getChar(index * 2));
    }

    public void copyFrom(int fromIndex, int thisIndex, UInt2Vector from) {
        BitVectorHelper.setValidityBit(this.validityBuffer, thisIndex, from.isSet(fromIndex));
        char value = from.valueBuffer.getChar(fromIndex * 2);
        this.valueBuffer.setChar(thisIndex * 2, value);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, UInt2Vector from) {
        this.handleSafe(thisIndex);
        this.copyFrom(fromIndex, thisIndex, from);
    }

    private void setValue(int index, int value) {
        this.valueBuffer.setChar(index * 2, value);
    }

    private void setValue(int index, char value) {
        this.valueBuffer.setChar(index * 2, value);
    }

    public void set(int index, int value) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, char value) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, NullableUInt2Holder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void set(int index, UInt2Holder holder) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, int value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, char value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableUInt2Holder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, UInt2Holder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setNull(int index) {
        this.handleSafe(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
    }

    public void set(int index, int isSet, char value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void setSafe(int index, int isSet, char value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((UInt2Vector)to);
    }

    private class TransferImpl
    implements TransferPair {
        UInt2Vector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new UInt2Vector(ref, UInt2Vector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(UInt2Vector to) {
            this.to = to;
        }

        @Override
        public UInt2Vector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            UInt2Vector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            UInt2Vector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, UInt2Vector.this);
        }
    }
}

