/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Base64;
import java.util.TimeZone;
import net.snowflake.client.core.BasicEvent;
import net.snowflake.client.core.ChunkDownloader;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.DownloaderMetrics;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFResultSetMetaData;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.core.SFStatementType;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.core.StmtUtil;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.jdbc.ArrowResultChunk;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinaryFormat;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SnowflakeDateTimeFormat;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.jdbc.telemetry.TelemetryData;
import net.snowflake.client.jdbc.telemetry.TelemetryField;
import net.snowflake.client.jdbc.telemetry.TelemetryUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SFArrowResultSet
extends SFBaseResultSet
implements DataConversionContext {
    static final SFLogger logger = SFLoggerFactory.getLogger(SFArrowResultSet.class);
    private ArrowResultChunk.ArrowChunkIterator currentChunkIterator;
    private String queryId;
    private SFStatementType statementType;
    private boolean totalRowCountTruncated;
    private boolean sortResult;
    protected SFStatement statement;
    private final boolean arrayBindSupported;
    private TimeZone timeZone;
    private long nextChunkIndex = 0L;
    private final long chunkCount;
    private ChunkDownloader chunkDownloader;
    private final long firstChunkTime;
    private final Telemetry telemetryClient;

    SFArrowResultSet(ResultUtil.ResultOutput resultOutput, SFStatement statement, boolean sortResult) throws SQLException {
        this(resultOutput, statement.getSession().getTelemetryClient(), sortResult);
        this.statement = statement;
        SFSession session = this.statement.getSession();
        session.setDatabase(resultOutput.getFinalDatabaseName());
        session.setSchema(resultOutput.getFinalSchemaName());
        session.setRole(resultOutput.getFinalRoleName());
        session.setWarehouse(resultOutput.getFinalWarehouseName());
        SessionUtil.updateSfDriverParamValues(this.parameters, statement.getSession());
        if (resultOutput.getSendResultTime() != 0L) {
            long timeConsumeFirstResult = this.firstChunkTime - resultOutput.getSendResultTime();
            this.logMetric(TelemetryField.TIME_CONSUME_FIRST_RESULT, timeConsumeFirstResult);
        }
        StmtUtil.eventHandler.triggerStateTransition(BasicEvent.QueryState.CONSUMING_RESULT, String.format(BasicEvent.QueryState.CONSUMING_RESULT.getArgString(), this.queryId, 0));
    }

    SFArrowResultSet(ResultUtil.ResultOutput resultOutput, Telemetry telemetryClient, boolean sortResult) throws SQLException {
        this.sortResult = sortResult;
        this.queryId = resultOutput.getQueryId();
        this.statementType = resultOutput.getStatementType();
        this.totalRowCountTruncated = resultOutput.isTotalRowCountTruncated();
        this.parameters = resultOutput.getParameters();
        this.chunkCount = resultOutput.getChunkCount();
        this.chunkDownloader = resultOutput.getChunkDownloader();
        this.timeZone = resultOutput.getTimeZone();
        this.honorClientTZForTimestampNTZ = resultOutput.isHonorClientTZForTimestampNTZ();
        this.resultVersion = resultOutput.getResultVersion();
        this.numberOfBinds = resultOutput.getNumberOfBinds();
        this.arrayBindSupported = resultOutput.isArrayBindSupported();
        this.metaDataOfBinds = resultOutput.getMetaDataOfBinds();
        this.telemetryClient = telemetryClient;
        this.firstChunkTime = System.currentTimeMillis();
        this.timestampNTZFormatter = resultOutput.getTimestampNTZFormatter();
        this.timestampLTZFormatter = resultOutput.getTimestampLTZFormatter();
        this.timestampTZFormatter = resultOutput.getTimestampTZFormatter();
        this.dateFormatter = resultOutput.getDateFormatter();
        this.timeFormatter = resultOutput.getTimeFormatter();
        this.timeZone = resultOutput.getTimeZone();
        this.honorClientTZForTimestampNTZ = resultOutput.isHonorClientTZForTimestampNTZ();
        this.binaryFormatter = resultOutput.getBinaryFormatter();
        String rowsetBase64 = resultOutput.getRowsetBase64();
        if (rowsetBase64 == null || rowsetBase64.isEmpty()) {
            this.currentChunkIterator = ArrowResultChunk.getEmptyChunkIterator();
        } else if (sortResult) {
            if (resultOutput.getChunkCount() > 0L) {
                throw new SnowflakeSQLException("0A000", ErrorCode.CLIENT_SIDE_SORTING_NOT_SUPPORTED.getMessageCode());
            }
            this.currentChunkIterator = this.getSortedFirstResultChunk(resultOutput.getRowsetBase64()).getIterator(this);
        } else {
            this.currentChunkIterator = this.buildFirstChunk(resultOutput.getRowsetBase64()).getIterator(this);
        }
        this.resultSetMetaData = new SFResultSetMetaData(resultOutput.getResultColumnMetadata(), this.queryId, this.session, this.timestampNTZFormatter, this.timestampLTZFormatter, this.timestampTZFormatter, this.dateFormatter, this.timeFormatter);
    }

    private boolean fetchNextRow() throws SnowflakeSQLException {
        if (this.sortResult) {
            return this.fetchNextRowSorted();
        }
        return this.fetchNextRowUnsorted();
    }

    private boolean fetchNextRowUnsorted() throws SnowflakeSQLException {
        boolean hasNext = this.currentChunkIterator.next();
        if (hasNext) {
            return true;
        }
        if (this.nextChunkIndex < this.chunkCount) {
            try {
                StmtUtil.eventHandler.triggerStateTransition(BasicEvent.QueryState.CONSUMING_RESULT, String.format(BasicEvent.QueryState.CONSUMING_RESULT.getArgString(), this.queryId, this.nextChunkIndex));
                ArrowResultChunk nextChunk = (ArrowResultChunk)this.chunkDownloader.getNextChunkToConsume();
                if (nextChunk == null) {
                    throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Expect chunk but got null for chunk index " + this.nextChunkIndex);
                }
                this.currentChunkIterator.getChunk().freeData();
                this.currentChunkIterator = nextChunk.getIterator(this);
                if (this.currentChunkIterator.next()) {
                    logger.debug("Moving to chunk index {}, row count={}", this.nextChunkIndex, nextChunk.getRowCount());
                    ++this.nextChunkIndex;
                    return true;
                }
                return false;
            }
            catch (InterruptedException ex) {
                throw new SnowflakeSQLException("57014", ErrorCode.INTERRUPTED.getMessageCode());
            }
        }
        if (this.chunkCount > 0L) {
            logger.debug("End of chunks");
            DownloaderMetrics metrics = this.chunkDownloader.terminate();
            this.logChunkDownloaderMetrics(metrics);
        }
        return false;
    }

    private ArrowResultChunk buildFirstChunk(String rowsetBase64) throws SQLException {
        byte[] bytes = Base64.getDecoder().decode(rowsetBase64);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ArrowResultChunk resultChunk = new ArrowResultChunk("", 0, 0, 0);
        try {
            ArrowResultChunk.readArrowStream(inputStream, resultChunk);
        }
        catch (IOException e) {
            throw new SnowflakeSQLException(ErrorCode.INTERNAL_ERROR, "Failed to load data in first chunk into arrow vector ex: " + e.getMessage());
        }
        return resultChunk;
    }

    private ArrowResultChunk getSortedFirstResultChunk(String rowsetBase64) {
        return null;
    }

    private boolean fetchNextRowSorted() {
        boolean hasNext = this.currentChunkIterator.next();
        if (hasNext) {
            return true;
        }
        this.currentChunkIterator.getChunk().freeData();
        return false;
    }

    @Override
    public boolean next() throws SFException, SnowflakeSQLException {
        if (this.isClosed()) {
            return false;
        }
        if (this.fetchNextRow()) {
            ++this.row;
            if (this.isLast()) {
                long timeConsumeLastResult = System.currentTimeMillis() - this.firstChunkTime;
                this.logMetric(TelemetryField.TIME_CONSUME_LAST_RESULT, timeConsumeLastResult);
            }
            return true;
        }
        logger.debug("end of result");
        if (this.totalRowCountTruncated || System.getProperty("snowflake.enable_incident_test2") != null && System.getProperty("snowflake.enable_incident_test2").equals("true")) {
            throw (SFException)IncidentUtil.generateIncidentV2WithException(this.session, new SFException(ErrorCode.MAX_RESULT_LIMIT_EXCEEDED, new Object[0]), this.queryId, null);
        }
        return false;
    }

    @Override
    public byte getByte(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toByte(index);
    }

    @Override
    public String getString(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toString(index);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toBoolean(index);
    }

    @Override
    public short getShort(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toShort(index);
    }

    @Override
    public int getInt(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toInt(index);
    }

    @Override
    public long getLong(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toLong(index);
    }

    @Override
    public float getFloat(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toFloat(index);
    }

    @Override
    public double getDouble(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toDouble(index);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toBytes(index);
    }

    @Override
    public Date getDate(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toDate(index);
    }

    @Override
    public Time getTime(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toTime(index);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, TimeZone tz) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toTimestamp(index, tz);
    }

    @Override
    public Object getObject(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toObject(index);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SFException {
        ArrowVectorConverter converter = this.currentChunkIterator.getCurrentConverter(columnIndex - 1);
        int index = this.currentChunkIterator.getCurrentRowInRecordBatch();
        this.wasNull = converter.isNull(index);
        return converter.toBigDecimal(index);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SFException {
        return this.getBigDecimal(columnIndex).setScale(scale, RoundingMode.HALF_UP);
    }

    @Override
    public boolean isLast() {
        return this.nextChunkIndex == this.chunkCount && this.currentChunkIterator.isLast();
    }

    @Override
    public boolean isAfterLast() {
        return this.nextChunkIndex == this.chunkCount && this.currentChunkIterator.isAfterLast();
    }

    @Override
    public void close() {
        super.close();
        if (this.chunkDownloader != null) {
            DownloaderMetrics metrics = this.chunkDownloader.terminate();
            this.logChunkDownloaderMetrics(metrics);
        }
    }

    @Override
    public SFStatementType getStatementType() {
        return this.statementType;
    }

    @Override
    public void setStatementType(SFStatementType statementType) {
        this.statementType = statementType;
    }

    @Override
    public boolean isArrayBindSupported() {
        return this.arrayBindSupported;
    }

    @Override
    public String getQueryId() {
        return this.queryId;
    }

    private void logMetric(TelemetryField field, long value) {
        TelemetryData data = TelemetryUtil.buildJobData(this.queryId, field, value);
        this.telemetryClient.tryAddLogToBatch(data);
    }

    private void logChunkDownloaderMetrics(DownloaderMetrics metrics) {
        if (metrics != null) {
            this.logMetric(TelemetryField.TIME_WAITING_FOR_CHUNKS, metrics.getMillisWaiting());
            this.logMetric(TelemetryField.TIME_DOWNLOADING_CHUNKS, metrics.getMillisDownloading());
            this.logMetric(TelemetryField.TIME_PARSING_CHUNKS, metrics.getMillisParsing());
        }
    }

    @Override
    public SnowflakeDateTimeFormat getTimestampLTZFormatter() {
        return this.timestampLTZFormatter;
    }

    @Override
    public SnowflakeDateTimeFormat getTimestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    @Override
    public SnowflakeDateTimeFormat getTimestampTZFormatter() {
        return this.timestampTZFormatter;
    }

    @Override
    public SnowflakeDateTimeFormat getDateFormatter() {
        return this.dateFormatter;
    }

    @Override
    public SnowflakeDateTimeFormat getTimeFormatter() {
        return this.timeFormatter;
    }

    @Override
    public SFBinaryFormat getBinaryFormatter() {
        return this.binaryFormatter;
    }

    @Override
    public int getScale(int columnIndex) {
        return this.resultSetMetaData.getScale(columnIndex);
    }

    @Override
    public SFSession getSession() {
        return this.session;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public boolean getHonorClientTZForTimestampNTZ() {
        return this.honorClientTZForTimestampNTZ;
    }

    @Override
    public long getResultVersion() {
        return this.resultVersion;
    }
}

