/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.snowflake.client.core.BasicEvent;
import net.snowflake.client.core.Event;
import net.snowflake.client.core.EventHandler;
import net.snowflake.client.core.Incident;

public class EventUtil {
    public static final String DUMP_PATH_PROP = "snowflake.dump_path";
    public static final String DUMP_SIZE_PROP = "snowflake.max_dump_size";
    public static final String DUMP_SUBDIR = "snowflake_dumps";
    private static final String DUMP_FILE_ID = UUID.randomUUID().toString();
    private static final String DUMP_PATH_PREFIX = System.getProperty("snowflake.dump_path") == null ? "/tmp" : System.getProperty("snowflake.dump_path");
    private static final long MAX_DUMP_FILE_SIZE_BYTES = System.getProperty("snowflake.max_dump_size") == null ? 0xA00000L : Long.valueOf(System.getProperty("snowflake.max_dump_size"));
    private static AtomicReference<EventHandler> eventHandler = new AtomicReference<Object>(null);
    private static int MAX_ENTRIES = 1000;
    private static int FLUSH_PERIOD_MS = 10000;

    public static synchronized void initEventHandlerInstance(int maxEntries, int flushPeriodMs) {
        if (eventHandler.get() == null) {
            eventHandler.set(new EventHandler(maxEntries, flushPeriodMs));
        }
    }

    public static EventHandler getEventHandlerInstance() {
        if (eventHandler.get() == null) {
            EventUtil.initEventHandlerInstance(MAX_ENTRIES, FLUSH_PERIOD_MS);
        }
        return eventHandler.get();
    }

    public static void triggerBasicEvent(Event.EventType type, String message, boolean flushBuffer) {
        EventHandler eh = eventHandler.get();
        if (eh != null) {
            eh.triggerBasicEvent(type, message, flushBuffer);
        }
    }

    public static void triggerStateTransition(BasicEvent.QueryState newState, String identifier) {
        EventHandler eh = eventHandler.get();
        if (eh != null) {
            eh.triggerStateTransition(newState, identifier);
        }
    }

    public static String getDumpPathPrefix() {
        return DUMP_PATH_PREFIX + "/" + DUMP_SUBDIR;
    }

    public static String getDumpFileId() {
        return DUMP_FILE_ID;
    }

    public static long getmaxDumpFileSizeBytes() {
        return MAX_DUMP_FILE_SIZE_BYTES;
    }

    public static void triggerIncident(Incident incident) {
        EventHandler eh = eventHandler.get();
        if (eh != null) {
            eh.triggerIncident(incident);
        }
    }
}

