/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.security.PrivateKey;
import java.util.regex.Pattern;
import net.snowflake.client.core.SFException;
import net.snowflake.client.jdbc.ErrorCode;

public enum SFSessionProperty {
    SERVER_URL("serverURL", true, String.class, new String[0]),
    USER("user", false, String.class, new String[0]),
    PASSWORD("password", false, String.class, new String[0]),
    ACCOUNT("account", true, String.class, new String[0]),
    DATABASE("database", false, String.class, "db"),
    SCHEMA("schema", false, String.class, new String[0]),
    PASSCODE_IN_PASSWORD("passcodeInPassword", false, Boolean.class, new String[0]),
    PASSCODE("passcode", false, String.class, new String[0]),
    TOKEN("token", false, String.class, new String[0]),
    ID_TOKEN("id_token", false, String.class, new String[0]),
    ID_TOKEN_PASSWORD("id_token_password", false, String.class, new String[0]),
    ROLE("role", false, String.class, new String[0]),
    AUTHENTICATOR("authenticator", false, String.class, new String[0]),
    PRIVATE_KEY("privateKey", false, PrivateKey.class, new String[0]),
    WAREHOUSE("warehouse", false, String.class, new String[0]),
    LOGIN_TIMEOUT("loginTimeout", false, Integer.class, new String[0]),
    NETWORK_TIMEOUT("networkTimeout", false, Integer.class, new String[0]),
    INJECT_SOCKET_TIMEOUT("injectSocketTimeout", false, Integer.class, new String[0]),
    INJECT_CLIENT_PAUSE("injectClientPause", false, Integer.class, new String[0]),
    APP_ID("appId", false, String.class, new String[0]),
    APP_VERSION("appVersion", false, String.class, new String[0]),
    OCSP_FAIL_OPEN("ocspFailOpen", false, Boolean.class, new String[0]),
    INSECURE_MODE("insecureMode", false, Boolean.class, new String[0]),
    QUERY_TIMEOUT("queryTimeout", false, Integer.class, new String[0]),
    APPLICATION("application", false, String.class, new String[0]),
    TRACING("tracing", false, String.class, new String[0]),
    DISABLE_SOCKS_PROXY("disableSocksProxy", false, Boolean.class, new String[0]),
    USE_PROXY("useProxy", false, Boolean.class, new String[0]),
    PROXY_HOST("proxyHost", false, String.class, new String[0]),
    PROXY_PORT("proxyPort", false, String.class, new String[0]),
    PROXY_USER("proxyUser", false, String.class, new String[0]),
    PROXY_PASSWORD("proxyPassword", false, String.class, new String[0]),
    NON_PROXY_HOSTS("nonProxyHosts", false, String.class, new String[0]);

    private String propertyKey;
    private boolean required;
    private Class valueType;
    private String[] aliases;
    static Pattern APPLICATION_REGEX;

    public boolean isRequired() {
        return this.required;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public Class getValueType() {
        return this.valueType;
    }

    private SFSessionProperty(String propertyKey, boolean required, Class valueType, String ... aliases) {
        this.propertyKey = propertyKey;
        this.required = required;
        this.valueType = valueType;
        this.aliases = aliases;
    }

    static SFSessionProperty lookupByKey(String propertyKey) {
        for (SFSessionProperty property : SFSessionProperty.values()) {
            if (property.propertyKey.equalsIgnoreCase(propertyKey)) {
                return property;
            }
            for (String alias : property.aliases) {
                if (!alias.equalsIgnoreCase(propertyKey)) continue;
                return property;
            }
        }
        return null;
    }

    static Object checkPropertyValue(SFSessionProperty property, Object propertyValue) throws SFException {
        if (propertyValue == null) {
            return null;
        }
        if (property.getValueType().isAssignableFrom(propertyValue.getClass())) {
            switch (property) {
                case APPLICATION: {
                    if (APPLICATION_REGEX.matcher((String)propertyValue).find()) {
                        return propertyValue;
                    }
                    throw new SFException(ErrorCode.INVALID_PARAMETER_VALUE, new Object[]{propertyValue, property});
                }
            }
            return propertyValue;
        }
        if (property.getValueType() == Boolean.class && propertyValue instanceof String) {
            if ("on".equalsIgnoreCase((String)propertyValue) || "true".equalsIgnoreCase((String)propertyValue)) {
                return true;
            }
            if ("off".equalsIgnoreCase((String)propertyValue) || "false".equalsIgnoreCase((String)propertyValue)) {
                return false;
            }
        } else if (property.getValueType() == Integer.class && propertyValue instanceof String) {
            return Integer.valueOf((String)propertyValue);
        }
        throw new SFException(ErrorCode.INVALID_PARAMETER_TYPE, propertyValue.getClass().getName(), property.getValueType().getName());
    }

    static {
        APPLICATION_REGEX = Pattern.compile("^[A-Za-z][A-Za-z0-9\\.\\-_]{1,50}$");
    }
}

