/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import net.snowflake.client.core.AssertUtil;
import net.snowflake.client.core.Event;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFTrustManager;
import net.snowflake.client.core.SessionUtilExternalBrowser;
import net.snowflake.client.core.SessionUtilKeyPair;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.apache.http.client.HttpClient;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpGet;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import net.snowflake.client.jdbc.internal.apache.http.client.utils.URIBuilder;
import net.snowflake.client.jdbc.internal.apache.http.entity.StringEntity;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.SystemDefaultHttpClient;
import net.snowflake.client.jdbc.internal.apache.http.message.BasicHeader;
import net.snowflake.client.jdbc.internal.apache.http.message.HeaderGroup;
import net.snowflake.client.jdbc.internal.apache.http.params.BasicHttpParams;
import net.snowflake.client.jdbc.internal.apache.http.params.HttpConnectionParams;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.org.jsoup.Jsoup;
import net.snowflake.client.jdbc.internal.org.jsoup.nodes.Document;
import net.snowflake.client.jdbc.internal.org.jsoup.select.Elements;
import net.snowflake.client.jdbc.internal.snowflake.common.core.ClientAuthnDTO;
import net.snowflake.client.jdbc.internal.snowflake.common.core.ClientAuthnParameter;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SessionUtil {
    public static final String SF_QUERY_DATABASE = "databaseName";
    public static final String SF_QUERY_SCHEMA = "schemaName";
    public static final String SF_QUERY_WAREHOUSE = "warehouse";
    public static final String SF_QUERY_ROLE = "roleName";
    public static final String SF_QUERY_REQUEST_ID = "requestId";
    public static final String SF_PATH_AUTHENTICATOR_REQUEST = "/session/authenticator-request";
    private static final String SF_PATH_LOGIN_REQUEST = "/session/v1/login-request";
    private static final String SF_PATH_TOKEN_REQUEST = "/session/token-request";
    public static final String SF_QUERY_SESSION_DELETE = "delete";
    private static final String SF_PATH_SESSION = "/session";
    private static ObjectMapper mapper = new ObjectMapper();
    public static final String SF_HEADER_AUTHORIZATION = "Authorization";
    public static final String SF_HEADER_BASIC_AUTHTYPE = "Basic";
    public static final String SF_HEADER_SNOWFLAKE_AUTHTYPE = "Snowflake";
    public static final String SF_HEADER_TOKEN_TAG = "Token";
    private static int DEFAULT_HTTP_CLIENT_CONNECTION_TIMEOUT = 60000;
    private static int DEFAULT_HTTP_CLIENT_SOCKET_TIMEOUT = 300000;
    private static int DEFAULT_HEALTH_CHECK_INTERVAL = 45;
    static final SFLogger logger = SFLoggerFactory.getLogger(SessionUtil.class);
    private static Set<String> STRING_PARAMS = new HashSet<String>(Arrays.asList("TIMEZONE", "TIMESTAMP_OUTPUT_FORMAT", "TIMESTAMP_NTZ_OUTPUT_FORMAT", "TIMESTAMP_LTZ_OUTPUT_FORMAT", "TIMESTAMP_TZ_OUTPUT_FORMAT", "DATE_OUTPUT_FORMAT", "TIME_OUTPUT_FORMAT", "BINARY_OUTPUT_FORMAT", "CLIENT_TIMESTAMP_TYPE_MAPPING"));
    private static Set<String> INT_PARAMS = new HashSet<String>(Arrays.asList("CLIENT_RESULT_PREFETCH_SLOTS", "CLIENT_RESULT_PREFETCH_THREADS", "CLIENT_PREFETCH_THREADS", "CLIENT_MEMORY_LIMIT"));
    private static Set<String> BOOLEAN_PARAMS = new HashSet<String>(Arrays.asList("CLIENT_HONOR_CLIENT_TZ_FOR_TIMESTAMP_NTZ", "JDBC_EXECUTE_RETURN_COUNT_FOR_DML", "CLIENT_DISABLE_INCIDENTS", "CLIENT_SESSION_KEEP_ALIVE", "JDBC_USE_JSON_PARSER", "AUTOCOMMIT", "JDBC_EFFICIENT_CHUNK_STORAGE", "JDBC_RS_COLUMN_CASE_INSENSITIVE", "CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX", "JDBC_TREAT_DECIMAL_AS_INT", "JDBC_ENABLE_COMBINED_DESCRIBE"));

    private static ClientAuthnDTO.AuthenticatorType getAuthenticator(LoginInput loginInput) {
        if (loginInput.getAuthenticator() != null) {
            if (loginInput.getAuthenticator().equalsIgnoreCase(ClientAuthnDTO.AuthenticatorType.EXTERNALBROWSER.name())) {
                return ClientAuthnDTO.AuthenticatorType.EXTERNALBROWSER;
            }
            if (loginInput.getAuthenticator().equalsIgnoreCase(ClientAuthnDTO.AuthenticatorType.OAUTH.name())) {
                return ClientAuthnDTO.AuthenticatorType.OAUTH;
            }
            if (loginInput.getAuthenticator().equalsIgnoreCase(ClientAuthnDTO.AuthenticatorType.SNOWFLAKE_JWT.name())) {
                return ClientAuthnDTO.AuthenticatorType.SNOWFLAKE_JWT;
            }
            if (!loginInput.getAuthenticator().equalsIgnoreCase(ClientAuthnDTO.AuthenticatorType.SNOWFLAKE.name())) {
                return ClientAuthnDTO.AuthenticatorType.OKTA;
            }
        }
        return loginInput.getPrivateKey() != null ? ClientAuthnDTO.AuthenticatorType.SNOWFLAKE_JWT : ClientAuthnDTO.AuthenticatorType.SNOWFLAKE;
    }

    public static LoginOutput openSession(LoginInput loginInput) throws SFException, SnowflakeSQLException {
        Map<String, Object> commonParams;
        String sessionRole;
        String sessionSchema;
        String sessionDatabase;
        long masterTokenValidityInSeconds;
        String remMeToken;
        String masterToken;
        String sessionToken;
        URI loginURI;
        AssertUtil.assertTrue(loginInput.getServerUrl() != null, "missing server URL for opening session");
        AssertUtil.assertTrue(loginInput.getUserName() != null, "missing user name for opening session");
        AssertUtil.assertTrue(loginInput.getAppId() != null, "missing app id for opening session");
        AssertUtil.assertTrue(loginInput.getHttpClient() != null, "missing http client for opening session");
        AssertUtil.assertTrue(loginInput.getLoginTimeout() >= 0, "negative login timeout for opening session");
        String tokenOrSamlResponse = null;
        String samlProofKey = null;
        String databaseVersion = null;
        int databaseMajorVersion = 0;
        int databaseMinorVersion = 0;
        String newClientForUpgrade = null;
        int healthCheckInterval = DEFAULT_HEALTH_CHECK_INTERVAL;
        int httpClientSocketTimeout = loginInput.getSocketTimeout();
        ClientAuthnDTO.AuthenticatorType authenticator = SessionUtil.getAuthenticator(loginInput);
        try {
            Object s;
            URIBuilder uriBuilder = new URIBuilder(loginInput.getServerUrl());
            if (loginInput.getDatabaseName() != null) {
                uriBuilder.addParameter(SF_QUERY_DATABASE, loginInput.getDatabaseName());
            }
            if (loginInput.getSchemaName() != null) {
                uriBuilder.addParameter(SF_QUERY_SCHEMA, loginInput.getSchemaName());
            }
            if (loginInput.getWarehouse() != null) {
                uriBuilder.addParameter(SF_QUERY_WAREHOUSE, loginInput.getWarehouse());
            }
            if (loginInput.getRole() != null) {
                uriBuilder.addParameter(SF_QUERY_ROLE, loginInput.getRole());
            }
            if (authenticator == ClientAuthnDTO.AuthenticatorType.EXTERNALBROWSER) {
                s = new SessionUtilExternalBrowser(loginInput);
                ((SessionUtilExternalBrowser)s).authenticate();
                tokenOrSamlResponse = ((SessionUtilExternalBrowser)s).getToken();
                samlProofKey = ((SessionUtilExternalBrowser)s).getProofKey();
            } else if (authenticator == ClientAuthnDTO.AuthenticatorType.OKTA) {
                tokenOrSamlResponse = SessionUtil.getSamlResponseUsingOkta(loginInput);
            } else if (authenticator == ClientAuthnDTO.AuthenticatorType.SNOWFLAKE_JWT) {
                s = new SessionUtilKeyPair(loginInput.getPrivateKey(), loginInput.getAccountName(), loginInput.getUserName());
                loginInput.setToken(((SessionUtilKeyPair)s).issueJwtToken());
            }
            uriBuilder.addParameter(SF_QUERY_REQUEST_ID, UUID.randomUUID().toString());
            uriBuilder.setPath(SF_PATH_LOGIN_REQUEST);
            loginURI = uriBuilder.build();
        }
        catch (URISyntaxException ex) {
            logger.error("Exception when building URL", ex);
            throw new SFException(ex, ErrorCode.INTERNAL_ERROR, "unexpected URI syntax exception:1");
        }
        if (loginInput.getServerUrl().indexOf(".privatelink.snowflakecomputing.com") > 0) {
            try {
                URL url = new URL(loginInput.getServerUrl());
                String host = url.getHost();
                logger.debug("HOST: {}", host);
                String ocspCacheServerUrl = String.format("http://ocsp%s/%s", host.substring(host.indexOf(46)), "ocsp_response_cache.json");
                logger.debug("OCSP Cache Server for Privatelink: {}", ocspCacheServerUrl);
                SFTrustManager.resetOCSPResponseCacherServerURL(ocspCacheServerUrl);
            }
            catch (IOException ex) {
                throw new SFException(ex, ErrorCode.INTERNAL_ERROR, "unexpected URL syntax exception");
            }
        }
        HttpClient httpClient = loginInput.getHttpClient();
        HttpPost postRequest = null;
        try {
            String clientInfoJSONStr;
            ClientAuthnDTO authnData = new ClientAuthnDTO();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(ClientAuthnParameter.CLIENT_APP_ID.name(), loginInput.getAppId());
            data.put(ClientAuthnParameter.LOGIN_NAME.name(), loginInput.getUserName());
            if (authenticator == ClientAuthnDTO.AuthenticatorType.SNOWFLAKE) {
                data.put(ClientAuthnParameter.PASSWORD.name(), loginInput.getPassword());
            } else if (authenticator == ClientAuthnDTO.AuthenticatorType.EXTERNALBROWSER) {
                data.put(ClientAuthnParameter.AUTHENTICATOR.name(), ClientAuthnDTO.AuthenticatorType.EXTERNALBROWSER.name());
                data.put(ClientAuthnParameter.PROOF_KEY.name(), samlProofKey);
                data.put(ClientAuthnParameter.TOKEN.name(), tokenOrSamlResponse);
            } else if (authenticator == ClientAuthnDTO.AuthenticatorType.OKTA) {
                data.put(ClientAuthnParameter.RAW_SAML_RESPONSE.name(), tokenOrSamlResponse);
            } else if (authenticator == ClientAuthnDTO.AuthenticatorType.OAUTH || authenticator == ClientAuthnDTO.AuthenticatorType.SNOWFLAKE_JWT) {
                data.put(ClientAuthnParameter.AUTHENTICATOR.name(), authenticator.name());
                data.put(ClientAuthnParameter.TOKEN.name(), loginInput.getToken());
            }
            HashMap<String, Object> clientEnv = new HashMap<String, Object>();
            clientEnv.put("OS", System.getProperty("os.name"));
            clientEnv.put("OS_VERSION", System.getProperty("os.version"));
            clientEnv.put("JAVA_VERSION", System.getProperty("java.version"));
            clientEnv.put("JAVA_RUNTIME", System.getProperty("java.runtime.name"));
            clientEnv.put("JAVA_VM", System.getProperty("java.vm.name"));
            boolean CRLEnabled = SessionUtil.checkCRLSystemProperty();
            clientEnv.put("CRL_ENABLED", CRLEnabled);
            if (loginInput.getApplication() != null) {
                clientEnv.put("APPLICATION", loginInput.getApplication());
            } else {
                String appName = System.getProperty("sun.java.command");
                if (appName != null) {
                    if (appName.indexOf(" ") > 0) {
                        appName = appName.substring(0, appName.indexOf(" "));
                    }
                    clientEnv.put("APPLICATION", appName);
                }
            }
            Properties clientInfo = loginInput.getClientInfo();
            if (clientInfo != null) {
                for (Map.Entry<Object, Object> property : clientInfo.entrySet()) {
                    if (property == null || property.getKey() == null || property.getValue() == null) continue;
                    clientEnv.put(property.getKey().toString(), property.getValue().toString());
                }
            }
            if ((clientInfoJSONStr = System.getProperty("snowflake.client.info")) != null) {
                JsonNode clientInfoJSON = null;
                try {
                    clientInfoJSON = mapper.readTree(clientInfoJSONStr);
                }
                catch (Throwable ex) {
                    logger.warn("failed to process snowflake.client.info property as JSON: " + clientInfoJSONStr, ex);
                }
                if (clientInfoJSON != null) {
                    Iterator<Map.Entry<String, JsonNode>> fields = clientInfoJSON.fields();
                    while (fields.hasNext()) {
                        Map.Entry<String, JsonNode> field = fields.next();
                        clientEnv.put(field.getKey(), field.getValue().asText());
                    }
                }
            }
            data.put(ClientAuthnParameter.CLIENT_ENVIRONMENT.name(), clientEnv);
            Map<String, Object> sessionParameter = loginInput.getSessionParameters();
            if (sessionParameter != null) {
                data.put(ClientAuthnParameter.SESSION_PARAMETERS.name(), loginInput.getSessionParameters());
            }
            if (loginInput.getAccountName() != null) {
                data.put(ClientAuthnParameter.ACCOUNT_NAME.name(), loginInput.getAccountName());
            }
            if (loginInput.isPasscodeInPassword()) {
                data.put(ClientAuthnParameter.EXT_AUTHN_DUO_METHOD.name(), "passcode");
            } else if (loginInput.getPasscode() != null) {
                data.put(ClientAuthnParameter.EXT_AUTHN_DUO_METHOD.name(), "passcode");
                data.put(ClientAuthnParameter.PASSCODE.name(), loginInput.getPasscode());
            } else {
                data.put(ClientAuthnParameter.EXT_AUTHN_DUO_METHOD.name(), "push");
            }
            logger.debug("implementation version = {}", SnowflakeDriver.implementVersion);
            data.put(ClientAuthnParameter.CLIENT_APP_VERSION.name(), loginInput.getAppVersion());
            authnData.setData(data);
            String json = mapper.writeValueAsString(authnData);
            postRequest = new HttpPost(loginURI);
            StringEntity input = new StringEntity(json, Charset.forName("UTF-8"));
            input.setContentType("application/json");
            postRequest.setEntity(input);
            postRequest.addHeader("accept", "application/json");
            postRequest.setHeader(SF_HEADER_AUTHORIZATION, SF_HEADER_BASIC_AUTHTYPE);
            String theString = HttpUtil.executeRequest(postRequest, loginInput.getHttpClient(), loginInput.getLoginTimeout(), 0, null);
            logger.debug("login response: {}", theString);
            JsonNode jsonNode = mapper.readTree(theString);
            if (!jsonNode.path("success").asBoolean()) {
                logger.debug("response = {}", theString);
                String errorCode = jsonNode.path("code").asText();
                throw new SnowflakeSQLException("08001", ErrorCode.CONNECTION_ERROR.getMessageCode(), errorCode, jsonNode.path("message").asText());
            }
            sessionToken = jsonNode.path("data").path("token").asText();
            masterToken = jsonNode.path("data").path("masterToken").asText();
            remMeToken = jsonNode.path("data").path("remMeToken").asText();
            masterTokenValidityInSeconds = jsonNode.path("data").path("masterValidityInSeconds").asLong();
            String serverVersion = jsonNode.path("data").path("serverVersion").asText();
            JsonNode dbNode = jsonNode.path("data").path("sessionInfo").path(SF_QUERY_DATABASE);
            sessionDatabase = dbNode.isNull() ? null : dbNode.asText();
            JsonNode schemaNode = jsonNode.path("data").path("sessionInfo").path(SF_QUERY_SCHEMA);
            sessionSchema = schemaNode.isNull() ? null : schemaNode.asText();
            JsonNode roleNode = jsonNode.path("data").path("sessionInfo").path(SF_QUERY_ROLE);
            sessionRole = roleNode.isNull() ? null : roleNode.asText();
            commonParams = SessionUtil.getCommonParams(jsonNode.path("data").path("parameters"));
            if (serverVersion != null) {
                logger.debug("server version = {}", serverVersion);
                databaseVersion = serverVersion.indexOf(" ") > 0 ? serverVersion.substring(0, serverVersion.indexOf(" ")) : serverVersion;
            } else {
                logger.warn("server version is null");
            }
            if (databaseVersion != null) {
                String[] components = databaseVersion.split("\\.");
                if (components != null && components.length >= 2) {
                    try {
                        databaseMajorVersion = Integer.parseInt(components[0]);
                        databaseMinorVersion = Integer.parseInt(components[1]);
                    }
                    catch (Exception ex) {
                        logger.error("Exception encountered when parsing server version: {} Exception: {}", databaseVersion, ex.getMessage());
                    }
                }
            } else {
                logger.warn("database version is null");
            }
            if (!jsonNode.path("data").path("newClientForUpgrade").isNull()) {
                newClientForUpgrade = jsonNode.path("data").path("newClientForUpgrade").asText();
                logger.debug("new client: {}", newClientForUpgrade);
            }
            int healthCheckIntervalFromGS = jsonNode.path("data").path("healthCheckInterval").asInt();
            logger.debug("health check interval = {}", healthCheckIntervalFromGS);
            if (healthCheckIntervalFromGS > 0 && healthCheckIntervalFromGS != healthCheckInterval) {
                healthCheckInterval = healthCheckIntervalFromGS;
                httpClientSocketTimeout = loginInput.getSocketTimeout() + healthCheckIntervalFromGS * 1000;
                BasicHttpParams httpParams = new BasicHttpParams();
                HttpConnectionParams.setConnectionTimeout(httpParams, loginInput.getConnectionTimeout());
                HttpConnectionParams.setSoTimeout(httpParams, httpClientSocketTimeout);
                ((SystemDefaultHttpClient)httpClient).setParams(httpParams);
                logger.debug("adjusted connection timeout to = {}", loginInput.getConnectionTimeout());
                logger.debug("adjusted socket timeout to = {}", httpClientSocketTimeout);
            }
        }
        catch (SnowflakeSQLException ex) {
            throw ex;
        }
        catch (IOException ex) {
            logger.error("IOException when creating session: " + postRequest, ex);
            throw new SnowflakeSQLException(ex, "58030", (int)ErrorCode.NETWORK_ERROR.getMessageCode(), "Exception encountered when opening connection: " + ex.getMessage());
        }
        catch (Throwable ex) {
            logger.error("Exception when creating session: " + postRequest, ex);
            throw new SnowflakeSQLException(ex, "08001", (int)ErrorCode.CONNECTION_ERROR.getMessageCode(), ErrorCode.CONNECTION_ERROR.getMessageCode(), ex.getMessage());
        }
        return new LoginOutput(sessionToken, masterToken, masterTokenValidityInSeconds, remMeToken, databaseVersion, databaseMajorVersion, databaseMinorVersion, newClientForUpgrade, healthCheckInterval, httpClientSocketTimeout, sessionDatabase, sessionSchema, sessionRole, commonParams);
    }

    public static LoginOutput renewSession(LoginInput loginInput) throws SFException, SnowflakeSQLException {
        String masterToken;
        String sessionToken;
        AssertUtil.assertTrue(loginInput.getServerUrl() != null, "missing server URL for renewing session");
        AssertUtil.assertTrue(loginInput.getSessionToken() != null, "missing session token for renewing session");
        AssertUtil.assertTrue(loginInput.getMasterToken() != null, "missing master token for renewing session");
        AssertUtil.assertTrue(loginInput.getHttpClient() != null, "missing http client for renewing session");
        AssertUtil.assertTrue(loginInput.getLoginTimeout() >= 0, "negative login timeout for renewing session");
        HttpPost postRequest = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(loginInput.getServerUrl());
            uriBuilder.setPath(SF_PATH_TOKEN_REQUEST);
            uriBuilder.addParameter(SF_QUERY_REQUEST_ID, UUID.randomUUID().toString());
            postRequest = new HttpPost(uriBuilder.build());
        }
        catch (URISyntaxException ex) {
            logger.error("Exception when creating http request", ex);
            throw new SFException(ex, ErrorCode.INTERNAL_ERROR, "unexpected URI syntax exception:3");
        }
        try {
            String json = "{\"oldSessionToken\":\"" + loginInput.getSessionToken() + "\", \"requestType\":" + 0 + "}";
            StringEntity input = new StringEntity(json, Charset.forName("UTF-8"));
            input.setContentType("application/json");
            postRequest.setEntity(input);
            postRequest.addHeader("accept", "application/json");
            postRequest.setHeader(SF_HEADER_AUTHORIZATION, "Snowflake Token=\"" + loginInput.getMasterToken() + "\"");
            logger.debug("old session token: {}, request type: 0, master token: {}", loginInput.getSessionToken(), loginInput.getMasterToken());
            String theString = HttpUtil.executeRequest(postRequest, loginInput.getHttpClient(), loginInput.getLoginTimeout(), 0, null);
            JsonNode jsonNode = mapper.readTree(theString);
            if (!jsonNode.path("success").asBoolean()) {
                logger.debug("response = {}", theString);
                String errorCode = jsonNode.path("code").asText();
                String message = jsonNode.path("message").asText();
                EventUtil.triggerBasicEvent(Event.EventType.NETWORK_ERROR, "SessionUtil:renewSession failure, error code=" + errorCode + ", message=" + message, true);
                SnowflakeUtil.checkErrorAndThrowException(jsonNode);
            }
            sessionToken = jsonNode.path("data").path("sessionToken").asText();
            masterToken = jsonNode.path("data").path("masterToken").asText();
        }
        catch (IOException ex) {
            logger.error("IOException when renewing session: " + postRequest, ex);
            throw new SFException(ex, ErrorCode.NETWORK_ERROR, ex.getMessage());
        }
        LoginOutput loginOutput = new LoginOutput();
        loginOutput.setSessionToken(sessionToken).setMasterToken(masterToken);
        return loginOutput;
    }

    public static void closeSession(LoginInput loginInput) throws SFException, SnowflakeSQLException {
        block4: {
            logger.debug(" public void close() throws SFException");
            AssertUtil.assertTrue(loginInput.getServerUrl() != null, "missing server URL for closing session");
            AssertUtil.assertTrue(loginInput.getSessionToken() != null, "missing session token for closing session");
            AssertUtil.assertTrue(loginInput.getHttpClient() != null, "missing http client for closing session");
            AssertUtil.assertTrue(loginInput.getLoginTimeout() >= 0, "missing login timeout for closing session");
            HttpPost postRequest = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(loginInput.getServerUrl());
                uriBuilder.addParameter(SF_QUERY_SESSION_DELETE, "true");
                uriBuilder.addParameter(SF_QUERY_REQUEST_ID, UUID.randomUUID().toString());
                uriBuilder.setPath(SF_PATH_SESSION);
                postRequest = new HttpPost(uriBuilder.build());
                postRequest.setHeader(SF_HEADER_AUTHORIZATION, "Snowflake Token=\"" + loginInput.getSessionToken() + "\"");
                String theString = HttpUtil.executeRequest(postRequest, loginInput.getHttpClient(), loginInput.getLoginTimeout(), 0, null);
                logger.debug("connection close response: {}", theString);
                JsonNode rootNode = mapper.readTree(theString);
                SnowflakeUtil.checkErrorAndThrowException(rootNode);
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException("unexpected URI syntax exception", ex);
            }
            catch (IOException ex) {
                logger.error("unexpected IO exception for: " + postRequest, ex);
            }
            catch (SnowflakeSQLException ex) {
                if (ex.getErrorCode() == 390112) break block4;
                throw ex;
            }
        }
    }

    private static String federatedFlowStep4(LoginInput loginInput, String ssoUrl, String oneTimeToken) throws SnowflakeSQLException {
        String responseHtml = "";
        try {
            URL url = new URL(ssoUrl);
            URI oktaGetUri = new URIBuilder().setScheme(url.getProtocol()).setHost(url.getHost()).setPath(url.getPath()).setParameter("RelayState", "%2Fsome%2Fdeep%2Flink").setParameter("onetimetoken", oneTimeToken).build();
            HttpGet httpGet = new HttpGet(oktaGetUri);
            HeaderGroup headers = new HeaderGroup();
            headers.addHeader(new BasicHeader("Accept", "*/*"));
            httpGet.setHeaders(headers.getAllHeaders());
            responseHtml = HttpUtil.executeRequest(httpGet, loginInput.getHttpClient(), loginInput.getLoginTimeout(), 0, null);
            String postBackUrl = SessionUtil.getPostBackUrlFromHTML(responseHtml);
            if (!SessionUtil.isPrefixEqual(postBackUrl, loginInput.getServerUrl())) {
                logger.debug("The specified authenticator {} and the destination URL in the SAML assertion {} do not match.", loginInput.getAuthenticator(), postBackUrl);
                throw new SnowflakeSQLException("08001", ErrorCode.IDP_INCORRECT_DESTINATION.getMessageCode());
            }
        }
        catch (IOException | URISyntaxException ex) {
            SessionUtil.handleFederatedFlowError(loginInput, ex);
        }
        return responseHtml;
    }

    private static String federatedFlowStep3(LoginInput loginInput, String tokenUrl) throws SnowflakeSQLException {
        String oneTimeToken = "";
        try {
            URL url = new URL(tokenUrl);
            URI tokenUri = url.toURI();
            HttpPost postRequest = new HttpPost(tokenUri);
            StringEntity params = new StringEntity("{\"username\":\"" + loginInput.getUserName() + "\",\"password\":\"" + loginInput.getPassword() + "\"}");
            postRequest.setEntity(params);
            HeaderGroup headers = new HeaderGroup();
            headers.addHeader(new BasicHeader("Accept", "application/json"));
            headers.addHeader(new BasicHeader("Content-Type", "application/json"));
            postRequest.setHeaders(headers.getAllHeaders());
            String idpResponse = HttpUtil.executeRequestWithoutCookies(postRequest, loginInput.getHttpClient(), loginInput.getLoginTimeout(), 0, null);
            logger.debug("user is authenticated against {}.", loginInput.getAuthenticator());
            JsonNode jsonNode = mapper.readTree(idpResponse);
            oneTimeToken = jsonNode.get("cookieToken").asText();
        }
        catch (IOException | URISyntaxException ex) {
            SessionUtil.handleFederatedFlowError(loginInput, ex);
        }
        return oneTimeToken;
    }

    private static void federatedFlowStep2(LoginInput loginInput, String tokenUrl, String ssoUrl) throws SnowflakeSQLException {
        try {
            if (!SessionUtil.isPrefixEqual(loginInput.getAuthenticator(), tokenUrl) || !SessionUtil.isPrefixEqual(loginInput.getAuthenticator(), ssoUrl)) {
                logger.debug("The specified authenticator {} is not supported.", loginInput.getAuthenticator());
                throw new SnowflakeSQLException("08001", ErrorCode.IDP_CONNECTION_ERROR.getMessageCode());
            }
        }
        catch (MalformedURLException ex) {
            SessionUtil.handleFederatedFlowError(loginInput, ex);
        }
    }

    private static JsonNode federatedFlowStep1(LoginInput loginInput) throws SnowflakeSQLException {
        JsonNode dataNode = null;
        try {
            URIBuilder fedUriBuilder = new URIBuilder(loginInput.getServerUrl());
            fedUriBuilder.setPath(SF_PATH_AUTHENTICATOR_REQUEST);
            URI fedUrlUri = fedUriBuilder.build();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(ClientAuthnParameter.ACCOUNT_NAME.name(), loginInput.getAccountName());
            data.put(ClientAuthnParameter.AUTHENTICATOR.name(), loginInput.getAuthenticator());
            data.put(ClientAuthnParameter.CLIENT_APP_ID.name(), loginInput.getAppId());
            data.put(ClientAuthnParameter.CLIENT_APP_VERSION.name(), loginInput.getAppVersion());
            ClientAuthnDTO authnData = new ClientAuthnDTO();
            authnData.setData(data);
            String json = mapper.writeValueAsString(authnData);
            StringEntity input = new StringEntity(json, Charset.forName("UTF-8"));
            input.setContentType("application/json");
            HttpPost postRequest = new HttpPost(fedUrlUri);
            postRequest.setEntity(input);
            postRequest.addHeader("accept", "application/json");
            String gsResponse = HttpUtil.executeRequest(postRequest, loginInput.getHttpClient(), loginInput.getLoginTimeout(), 0, null);
            logger.debug("authenticator-request response: {}", gsResponse);
            JsonNode jsonNode = mapper.readTree(gsResponse);
            if (!jsonNode.path("success").asBoolean()) {
                logger.debug("response = {}", gsResponse);
                String errorCode = jsonNode.path("code").asText();
                throw new SnowflakeSQLException("08001", ErrorCode.CONNECTION_ERROR.getMessageCode(), errorCode, jsonNode.path("message").asText());
            }
            dataNode = jsonNode.path("data");
        }
        catch (IOException | URISyntaxException ex) {
            SessionUtil.handleFederatedFlowError(loginInput, ex);
        }
        return dataNode;
    }

    private static void handleFederatedFlowError(LoginInput loginInput, Exception ex) throws SnowflakeSQLException {
        if (ex instanceof IOException) {
            logger.error("IOException when authenticating with " + loginInput.getAuthenticator(), ex);
            throw new SnowflakeSQLException(ex, "58030", (int)ErrorCode.NETWORK_ERROR.getMessageCode(), "Exception encountered when opening connection: " + ex.getMessage());
        }
        logger.error("Exception when authenticating with " + loginInput.getAuthenticator(), ex);
        throw new SnowflakeSQLException(ex, "08001", (int)ErrorCode.CONNECTION_ERROR.getMessageCode(), ErrorCode.CONNECTION_ERROR.getMessageCode(), ex.getMessage());
    }

    private static String getSamlResponseUsingOkta(LoginInput loginInput) throws SnowflakeSQLException {
        JsonNode dataNode = SessionUtil.federatedFlowStep1(loginInput);
        String tokenUrl = dataNode.path("tokenUrl").asText();
        String ssoUrl = dataNode.path("ssoUrl").asText();
        SessionUtil.federatedFlowStep2(loginInput, tokenUrl, ssoUrl);
        String oneTimeToken = SessionUtil.federatedFlowStep3(loginInput, tokenUrl);
        String responseHtml = SessionUtil.federatedFlowStep4(loginInput, ssoUrl, oneTimeToken);
        return responseHtml;
    }

    static boolean isPrefixEqual(String aUrlStr, String bUrlStr) throws MalformedURLException {
        URL aUrl = new URL(aUrlStr);
        URL bUrl = new URL(bUrlStr);
        int aPort = aUrl.getPort();
        int bPort = bUrl.getPort();
        if (aPort == -1 && "https".equals(aUrl.getProtocol())) {
            aPort = 443;
        }
        if (bPort == -1 && "https".equals(bUrl.getProtocol())) {
            bPort = 443;
        }
        return aUrl.getHost().equalsIgnoreCase(bUrl.getHost()) && aUrl.getProtocol().equalsIgnoreCase(bUrl.getProtocol()) && aPort == bPort;
    }

    private static String getPostBackUrlFromHTML(String html) {
        Document doc = Jsoup.parse(html);
        Elements e1 = doc.getElementsByTag("body");
        Elements e2 = e1.get(0).getElementsByTag("form");
        String postBackUrl = e2.first().attr("action");
        return postBackUrl;
    }

    public static boolean checkCRLSystemProperty() {
        String enableCRLDP = System.getProperty("com.sun.security.enableCRLDP");
        String checkRevocation = System.getProperty("com.sun.net.ssl.checkRevocation");
        boolean CRLEnabled = false;
        if (enableCRLDP != null && "true".equalsIgnoreCase(enableCRLDP) && checkRevocation != null && "true".equalsIgnoreCase(checkRevocation)) {
            CRLEnabled = true;
        }
        return CRLEnabled;
    }

    public static Map<String, Object> getCommonParams(JsonNode paramsNode) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (JsonNode child : paramsNode) {
            if (!child.hasNonNull("name")) {
                logger.error("Common Parameter JsonNode encountered with no parameter name!");
                continue;
            }
            String paramName = child.path("name").asText();
            if (!child.hasNonNull("value")) {
                logger.debug("No value found for Common Parameter {}", child.path("name").asText());
                continue;
            }
            if (STRING_PARAMS.contains(paramName.toUpperCase())) {
                parameters.put(paramName, child.path("value").asText());
            } else if (INT_PARAMS.contains(paramName.toUpperCase())) {
                parameters.put(paramName, child.path("value").asInt());
            } else if (BOOLEAN_PARAMS.contains(paramName.toUpperCase())) {
                parameters.put(paramName, child.path("value").asBoolean());
            } else {
                logger.debug("Unknown Common Parameter: {}", paramName);
            }
            logger.debug("Parameter {}: {}", paramName, child.path("value").asText());
        }
        return parameters;
    }

    public static void updateSfDriverParamValues(Map<String, Object> parameters, SFSession session) {
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            logger.debug("processing parameter {}", entry.getKey());
            if ("CLIENT_DISABLE_INCIDENTS".equalsIgnoreCase(entry.getKey())) {
                SnowflakeDriver.setDisableIncidents((Boolean)entry.getValue());
                continue;
            }
            if ("JDBC_EXECUTE_RETURN_COUNT_FOR_DML".equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setExecuteReturnCountForDML((Boolean)entry.getValue());
                continue;
            }
            if ("CLIENT_SESSION_KEEP_ALIVE".equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setEnableHeartbeat((Boolean)entry.getValue());
                continue;
            }
            if ("AUTOCOMMIT".equalsIgnoreCase(entry.getKey())) {
                boolean autoCommit = (Boolean)entry.getValue();
                if (session == null || session.getAutoCommit() == autoCommit) continue;
                session.setAutoCommit(autoCommit);
                continue;
            }
            if ("JDBC_RS_COLUMN_CASE_INSENSITIVE".equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setRsColumnCaseInsensitive((Boolean)entry.getValue());
                continue;
            }
            if ("CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX".equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setMetadataRequestUseConnectionCtx((Boolean)entry.getValue());
                continue;
            }
            if ("CLIENT_TIMESTAMP_TYPE_MAPPING".equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setTimestampMappedType(SnowflakeType.valueOf(((String)entry.getValue()).toUpperCase()));
                continue;
            }
            if ("JDBC_TREAT_DECIMAL_AS_INT".equalsIgnoreCase(entry.getKey())) {
                if (session == null) continue;
                session.setJdbcTreatDecimalAsInt((Boolean)entry.getValue());
                continue;
            }
            if (!"JDBC_ENABLE_COMBINED_DESCRIBE".equalsIgnoreCase(entry.getKey()) || session == null) continue;
            session.setEnableCombineDescribe((Boolean)entry.getValue());
        }
    }

    static /* synthetic */ int access$000() {
        return DEFAULT_HTTP_CLIENT_CONNECTION_TIMEOUT;
    }

    static /* synthetic */ int access$100() {
        return DEFAULT_HTTP_CLIENT_SOCKET_TIMEOUT;
    }

    public static class LoginOutput {
        String sessionToken;
        String masterToken;
        long masterTokenValidityInSeconds;
        String remMeToken;
        String databaseVersion;
        int databaseMajorVersion;
        int databaseMinorVersion;
        String newClientForUpgrade;
        int healthCheckInterval;
        int httpClientSocketTimeout;
        String sessionDatabase;
        String sessionSchema;
        String sessionRole;
        Map<String, Object> commonParams;

        public LoginOutput() {
        }

        public LoginOutput(String sessionToken, String masterToken, long masterTokenValidityInSeconds, String remMeToken, String databaseVersion, int databaseMajorVersion, int databaseMinorVersion, String newClientForUpgrade, int healthCheckInterval, int httpClientSocketTimeout, String sessionDatabase, String sessionSchema, String sessionRole, Map<String, Object> commonParams) {
            this.sessionToken = sessionToken;
            this.masterToken = masterToken;
            this.remMeToken = remMeToken;
            this.databaseVersion = databaseVersion;
            this.databaseMajorVersion = databaseMajorVersion;
            this.databaseMinorVersion = databaseMinorVersion;
            this.newClientForUpgrade = newClientForUpgrade;
            this.healthCheckInterval = healthCheckInterval;
            this.httpClientSocketTimeout = httpClientSocketTimeout;
            this.sessionDatabase = sessionDatabase;
            this.sessionSchema = sessionSchema;
            this.sessionRole = sessionRole;
            this.commonParams = commonParams;
            this.masterTokenValidityInSeconds = masterTokenValidityInSeconds;
        }

        public LoginOutput setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public LoginOutput setMasterToken(String masterToken) {
            this.masterToken = masterToken;
            return this;
        }

        public LoginOutput setRemMeToken(String remMeToken) {
            this.remMeToken = remMeToken;
            return this;
        }

        public LoginOutput setDatabaseVersion(String databaseVersion) {
            this.databaseVersion = databaseVersion;
            return this;
        }

        public LoginOutput setDatabaseMajorVersion(int databaseMajorVersion) {
            this.databaseMajorVersion = databaseMajorVersion;
            return this;
        }

        public LoginOutput setDatabaseMinorVersion(int databaseMinorVersion) {
            this.databaseMinorVersion = databaseMinorVersion;
            return this;
        }

        public LoginOutput setNewClientForUpgrade(String newClientForUpgrade) {
            this.newClientForUpgrade = newClientForUpgrade;
            return this;
        }

        public LoginOutput setHealthCheckInterval(int healthCheckInterval) {
            this.healthCheckInterval = healthCheckInterval;
            return this;
        }

        public LoginOutput setHttpClientSocketTimeout(int httpClientSocketTimeout) {
            this.httpClientSocketTimeout = httpClientSocketTimeout;
            return this;
        }

        public LoginOutput setCommonParams(Map<String, Object> commonParams) {
            this.commonParams = commonParams;
            return this;
        }

        public String getSessionToken() {
            return this.sessionToken;
        }

        public String getMasterToken() {
            return this.masterToken;
        }

        public String getRemMeToken() {
            return this.remMeToken;
        }

        public String getDatabaseVersion() {
            return this.databaseVersion;
        }

        public int getDatabaseMajorVersion() {
            return this.databaseMajorVersion;
        }

        public int getDatabaseMinorVersion() {
            return this.databaseMinorVersion;
        }

        public String getNewClientForUpgrade() {
            return this.newClientForUpgrade;
        }

        public int getHealthCheckInterval() {
            return this.healthCheckInterval;
        }

        public int getHttpClientSocketTimeout() {
            return this.httpClientSocketTimeout;
        }

        public Map<String, Object> getCommonParams() {
            return this.commonParams;
        }

        public String getSessionDatabase() {
            return this.sessionDatabase;
        }

        public void setSessionDatabase(String sessionDatabase) {
            this.sessionDatabase = sessionDatabase;
        }

        public String getSessionSchema() {
            return this.sessionSchema;
        }

        public void setSessionSchema(String sessionSchema) {
            this.sessionSchema = sessionSchema;
        }

        public String getSessionRole() {
            return this.sessionRole;
        }

        public long getMasterTokenValidityInSeconds() {
            return this.masterTokenValidityInSeconds;
        }
    }

    public static class LoginInput {
        private String serverUrl;
        private String databaseName;
        private String schemaName;
        private String warehouse;
        private String role;
        private String authenticator;
        private HttpClient httpClient;
        private String accountName;
        private int loginTimeout = -1;
        private String userName;
        private String password;
        private Properties clientInfo;
        private boolean passcodeInPassword;
        private String passcode;
        private String token;
        private int connectionTimeout = SessionUtil.access$000();
        private int socketTimeout = SessionUtil.access$100();
        private String appId;
        private String appVersion;
        private String sessionToken;
        private String masterToken;
        private Map<String, Object> sessionParameters;
        private PrivateKey privateKey;
        private String application;

        public LoginInput setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public LoginInput setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public LoginInput setSchemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public LoginInput setWarehouse(String warehouse) {
            this.warehouse = warehouse;
            return this;
        }

        public LoginInput setRole(String role) {
            this.role = role;
            return this;
        }

        public LoginInput setAuthenticator(String authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        public LoginInput setHttpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public LoginInput setAccountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public LoginInput setLoginTimeout(int loginTimeout) {
            this.loginTimeout = loginTimeout;
            return this;
        }

        public LoginInput setUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public LoginInput setPassword(String password) {
            this.password = password;
            return this;
        }

        public LoginInput setToken(String token) {
            this.token = token;
            return this;
        }

        public LoginInput setClientInfo(Properties clientInfo) {
            this.clientInfo = clientInfo;
            return this;
        }

        public LoginInput setPasscodeInPassword(boolean passcodeInPassword) {
            this.passcodeInPassword = passcodeInPassword;
            return this;
        }

        public LoginInput setPasscode(String passcode) {
            this.passcode = passcode;
            return this;
        }

        public LoginInput setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public LoginInput setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public LoginInput setAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public LoginInput setAppVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public LoginInput setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public LoginInput setMasterToken(String masterToken) {
            this.masterToken = masterToken;
            return this;
        }

        public LoginInput setSessionParameters(Map<String, Object> sessionParameters) {
            this.sessionParameters = sessionParameters;
            return this;
        }

        public LoginInput setPrivateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public LoginInput setApplication(String application) {
            this.application = application;
            return this;
        }

        public HttpClient getHttpClient() {
            return this.httpClient;
        }

        public String getServerUrl() {
            return this.serverUrl;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getWarehouse() {
            return this.warehouse;
        }

        public String getRole() {
            return this.role;
        }

        public String getAuthenticator() {
            return this.authenticator;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public int getLoginTimeout() {
            return this.loginTimeout;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        public Properties getClientInfo() {
            return this.clientInfo;
        }

        public String getPasscode() {
            return this.passcode;
        }

        public String getToken() {
            return this.token;
        }

        public int getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public int getSocketTimeout() {
            return this.socketTimeout;
        }

        public boolean isPasscodeInPassword() {
            return this.passcodeInPassword;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getAppVersion() {
            return this.appVersion;
        }

        public String getSessionToken() {
            return this.sessionToken;
        }

        public String getMasterToken() {
            return this.masterToken;
        }

        public Map<String, Object> getSessionParameters() {
            return this.sessionParameters;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public String getApplication() {
            return this.application;
        }
    }
}

