/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.net.URISyntaxException;
import net.snowflake.client.jdbc.cloud.storage.StorageProviderException;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.S3ObjectSummary;
import net.snowflake.client.jdbc.internal.amazonaws.util.Base64;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageException;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.BlobProperties;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.CloudBlob;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.ListBlobItem;

public class StorageObjectSummary {
    private String location;
    private String key;
    private String md5;
    private long size;

    private StorageObjectSummary(String location, String key, String md5, long size) {
        this.location = location;
        this.key = key;
        this.md5 = md5;
        this.size = size;
    }

    public static StorageObjectSummary createFromS3ObjectSummary(S3ObjectSummary objSummary) {
        return new StorageObjectSummary(objSummary.getBucketName(), objSummary.getKey(), objSummary.getETag(), objSummary.getSize());
    }

    public static StorageObjectSummary createFromAzureListBlobItem(ListBlobItem listBlobItem) throws StorageProviderException {
        long size;
        String md5;
        String key;
        String location;
        try {
            location = listBlobItem.getContainer().getName();
            CloudBlob cloudBlob = (CloudBlob)listBlobItem;
            key = cloudBlob.getName();
            BlobProperties blobProperties = cloudBlob.getProperties();
            md5 = StorageObjectSummary.convertBase64ToHex(blobProperties.getContentMD5());
            size = blobProperties.getLength();
        }
        catch (URISyntaxException | StorageException ex) {
            throw new StorageProviderException(ex);
        }
        return new StorageObjectSummary(location, key, md5, size);
    }

    private static String convertBase64ToHex(String base64String) {
        try {
            byte[] bytes = Base64.decode(base64String);
            StringBuilder builder = new StringBuilder();
            for (byte b : bytes) {
                builder.append(String.format("%02x", b));
            }
            return builder.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getLocation() {
        return this.location;
    }

    public String getKey() {
        return this.key;
    }

    public String getMD5() {
        return this.md5;
    }

    public long getSize() {
        return this.size;
    }
}

