/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.microsoft.azure.storage.table;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.OperationContext;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageException;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.table.EntityProperty;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.table.PropertyPair;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.table.TableEntity;

public class TableServiceEntity
implements TableEntity {
    private static final int DEFAULT_CONCURRENCY_MULTIPLIER = 4;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_INITIAL_CAPACITY = 31;
    private static boolean disableReflectedEntityCache = false;
    protected String partitionKey = null;
    protected String rowKey = null;
    protected String etag = null;
    protected Date timeStamp = new Date();
    private static ConcurrentHashMap<Class<?>, HashMap<String, PropertyPair>> reflectedEntityCache = TableServiceEntity.initialize();

    public static void readEntityWithReflection(Object instance, HashMap<String, EntityProperty> properties, OperationContext opContext) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        HashMap<String, PropertyPair> props = PropertyPair.generatePropertyPairs(instance.getClass());
        for (Map.Entry<String, EntityProperty> p : properties.entrySet()) {
            if (!props.containsKey(p.getKey())) continue;
            props.get(p.getKey()).consumeEntityProperty(p.getValue(), instance);
        }
    }

    public static HashMap<String, EntityProperty> writeEntityWithReflection(Object instance) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        HashMap<String, PropertyPair> props = PropertyPair.generatePropertyPairs(instance.getClass());
        HashMap<String, EntityProperty> retVal = new HashMap<String, EntityProperty>();
        for (Map.Entry<String, PropertyPair> p : props.entrySet()) {
            retVal.put(p.getValue().effectiveName, p.getValue().generateEntityProperty(instance));
        }
        return retVal;
    }

    public TableServiceEntity() {
    }

    public TableServiceEntity(String partitionKey, String rowKey) {
        this.partitionKey = partitionKey;
        this.rowKey = rowKey;
    }

    @Override
    public String getEtag() {
        return this.etag;
    }

    @Override
    public String getPartitionKey() {
        return this.partitionKey;
    }

    @Override
    public String getRowKey() {
        return this.rowKey;
    }

    @Override
    public Date getTimestamp() {
        return this.timeStamp;
    }

    public static boolean isReflectedEntityCacheDisabled() {
        return disableReflectedEntityCache;
    }

    public static void setReflectedEntityCacheDisabled(boolean disableReflectedEntityCache) {
        if (reflectedEntityCache != null && disableReflectedEntityCache) {
            reflectedEntityCache.clear();
        }
        TableServiceEntity.disableReflectedEntityCache = disableReflectedEntityCache;
    }

    @Override
    public void readEntity(HashMap<String, EntityProperty> properties, OperationContext opContext) throws StorageException {
        try {
            TableServiceEntity.readEntityWithReflection(this, properties, opContext);
        }
        catch (IllegalArgumentException e) {
            throw new StorageException("InvalidDocument", "The response received is invalid or improperly formatted.", 306, null, e);
        }
        catch (IllegalAccessException e) {
            throw new StorageException("InvalidDocument", "The entity threw an exception during deserialization.", 306, null, e);
        }
        catch (InvocationTargetException e) {
            throw new StorageException("InternalError", "The entity threw an exception during deserialization.", 306, null, e);
        }
    }

    @Override
    public void setEtag(String etag) {
        this.etag = etag;
    }

    @Override
    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    @Override
    public void setRowKey(String rowKey) {
        this.rowKey = rowKey;
    }

    @Override
    public void setTimestamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public HashMap<String, EntityProperty> writeEntity(OperationContext opContext) throws StorageException {
        try {
            return TableServiceEntity.writeEntityWithReflection(this);
        }
        catch (IllegalAccessException e) {
            throw new StorageException("InternalError", "An attempt was made to access an inaccessible member of the entity during serialization.", 306, null, e);
        }
        catch (InvocationTargetException e) {
            throw new StorageException("InternalError", "The entity threw an exception during serialization.", 306, null, e);
        }
    }

    private static ConcurrentHashMap<Class<?>, HashMap<String, PropertyPair>> initialize() {
        Runtime runtime = Runtime.getRuntime();
        int numberOfProcessors = runtime.availableProcessors();
        return new ConcurrentHashMap(31, 0.75f, numberOfProcessors * 4);
    }

    protected static ConcurrentHashMap<Class<?>, HashMap<String, PropertyPair>> getReflectedEntityCache() {
        return reflectedEntityCache;
    }
}

