/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.SQLException;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.internal.snowflake.common.core.ResourceBundleManager;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SnowflakeSQLException
extends SQLException {
    static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeSQLException.class);
    static final ResourceBundleManager errorResourceBundleManager = ResourceBundleManager.getSingleton("net.snowflake.client.jdbc.jdbc_error_messages");
    private String queryId = "unknown";

    public SnowflakeSQLException(String queryId, String reason, String sqlState, int vendorCode) {
        super(reason, sqlState, vendorCode);
        this.queryId = queryId;
        logger.debug("Snowflake exception: {}, sqlState:{}, vendorCode:{}, queryId:{}", reason, sqlState, vendorCode, queryId);
    }

    public SnowflakeSQLException(String sqlState, int vendorCode) {
        super(errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode)), sqlState, vendorCode);
        logger.debug("Snowflake exception: {}, sqlState:{}, vendorCode:{}", errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode)), sqlState, vendorCode);
    }

    public SnowflakeSQLException(String sqlState, int vendorCode, Object ... params) {
        super(errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode), params), sqlState, vendorCode);
        logger.debug("Snowflake exception: {}, sqlState:{}, vendorCode:{}", errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode), params), sqlState, vendorCode);
    }

    public SnowflakeSQLException(Throwable ex, String sqlState, int vendorCode) {
        super(errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode)), sqlState, vendorCode, ex);
        logger.debug("Snowflake exception: {}" + errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode)), ex);
    }

    public SnowflakeSQLException(Throwable ex, String sqlState, int vendorCode, Object ... params) {
        super(errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode), params), sqlState, vendorCode, ex);
        logger.debug("Snowflake exception: " + errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode), params), ex);
    }

    public SnowflakeSQLException(ErrorCode errorCode, Object ... params) {
        super(errorResourceBundleManager.getLocalizedMessage(String.valueOf(errorCode.getMessageCode()), params), errorCode.getSqlState(), errorCode.getMessageCode());
    }

    public String getQueryId() {
        return this.queryId;
    }
}

