/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsAnonymous;
import com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.CloudAppendBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.FileBackedOutputStream;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.cloud.storage.AzureObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeS3Client;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeStorageClient;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectSummaryCollection;
import net.snowflake.client.jdbc.cloud.storage.StorageProviderException;
import net.snowflake.client.jdbc.internal.apache.commons.io.IOUtils;
import net.snowflake.client.jdbc.internal.apache.commons.lang3.tuple.ImmutablePair;
import net.snowflake.client.jdbc.internal.apache.commons.lang3.tuple.Pair;
import net.snowflake.client.jdbc.internal.snowflake.common.core.RemoteStoreFileEncryptionMaterial;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SnowflakeAzureClient
implements SnowflakeStorageClient {
    private static final String localFileSep = System.getProperty("file.separator");
    private StageInfo stageInfo;
    private RemoteStoreFileEncryptionMaterial encMat;
    private CloudBlobClient azStorageClient;
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeS3Client.class);

    private SnowflakeAzureClient() {
    }

    public static SnowflakeAzureClient createSnowflakeAzureClient(StageInfo stage, RemoteStoreFileEncryptionMaterial encMat) {
        SnowflakeAzureClient azureClient = new SnowflakeAzureClient();
        azureClient.setupAzureClient(stage, encMat);
        return azureClient;
    }

    private void setupAzureClient(StageInfo stage, RemoteStoreFileEncryptionMaterial encMat) throws IllegalArgumentException {
        this.stageInfo = stage;
        this.encMat = encMat;
        logger.debug("Setting up the Azure client ");
        try {
            URI storageEndpoint = SnowflakeAzureClient.buildAzureStorageEndpointURI(stage.getEndPoint(), stage.getStorageAccount());
            String sasToken = (String)stage.getCredentials().get("AZURE_SAS_TOKEN");
            StorageCredentials azCreds = sasToken != null ? new StorageCredentialsSharedAccessSignature(sasToken) : StorageCredentialsAnonymous.ANONYMOUS;
            this.azStorageClient = new CloudBlobClient(storageEndpoint, azCreds);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("invalid_azure_credentials");
        }
    }

    @Override
    public int getMaxRetries() {
        return 25;
    }

    @Override
    public int getRetryBackoffMaxExponent() {
        return 4;
    }

    @Override
    public int getRetryBackoffMin() {
        return 1000;
    }

    @Override
    public boolean isEncrypting() {
        return false;
    }

    @Override
    public int getEncryptionKeySize() {
        return 0;
    }

    @Override
    public void renew(Map stageCredentials) throws SnowflakeSQLException {
        this.stageInfo.setCredentials(stageCredentials);
        this.setupAzureClient(this.stageInfo, this.encMat);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public StorageObjectSummaryCollection listObjects(String remoteStorageLocation, String prefix) throws StorageProviderException {
        StorageObjectSummaryCollection storageObjectSummaries;
        try {
            CloudBlobContainer container = this.azStorageClient.getContainerReference(remoteStorageLocation);
            Iterable<ListBlobItem> listBlobItemIterable = container.listBlobs(prefix, true);
            storageObjectSummaries = new StorageObjectSummaryCollection(listBlobItemIterable);
        }
        catch (StorageException | URISyntaxException ex) {
            logger.debug("Failed to list objects: {}", ex);
            throw new StorageProviderException(ex);
        }
        return storageObjectSummaries;
    }

    @Override
    public StorageObjectMetadata getObjectMetadata(String remoteStorageLocation, String prefix) throws StorageProviderException {
        AzureObjectMetadata azureObjectMetadata = null;
        try {
            CloudBlobContainer container = this.azStorageClient.getContainerReference(remoteStorageLocation);
            CloudAppendBlob blob = container.getAppendBlobReference(prefix);
            HashMap<String, String> userDefinedMetadata = blob.getMetadata();
            BlobProperties properties = blob.getProperties();
            long contentLength = properties.getLength();
            String contentEncoding = properties.getContentEncoding();
            azureObjectMetadata = new AzureObjectMetadata(contentLength, contentEncoding, userDefinedMetadata);
        }
        catch (StorageException ex) {
            logger.debug("Failed to retrieve BLOB metadata: {} - {}", ex.getErrorCode(), ex.getExtendedErrorInformation());
            throw new StorageProviderException(ex);
        }
        catch (URISyntaxException ex) {
            logger.debug("Cannot retrieve BLOB properties, invalid URI: {}", ex);
            throw new StorageProviderException(ex);
        }
        return azureObjectMetadata;
    }

    @Override
    public void download(SFSession connection, String command, String localLocation, String destFileName, int parallelism, String remoteStorageLocation, String stageFilePath, String stageRegion) throws SnowflakeSQLException {
        int retryCount = 0;
        while (true) {
            try {
                FileOutputStream outStream = new FileOutputStream(localLocation + localFileSep + destFileName);
                CloudBlobContainer container = this.azStorageClient.getContainerReference(remoteStorageLocation);
                CloudBlockBlob blob = container.getBlockBlobReference(stageFilePath);
                blob.download(outStream);
                return;
            }
            catch (Exception ex) {
                logger.debug("Download unsuccessful {}", ex);
                SnowflakeAzureClient.handleAzureException(ex, ++retryCount, "download", connection, command, this);
                if (retryCount <= this.getMaxRetries()) continue;
                throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Unexpected: download unsuccessful without exception!");
            }
            break;
        }
    }

    @Override
    public void upload(SFSession connection, String command, int parallelism, boolean uploadFromStream, String remoteStorageLocation, File srcFile, String destFileName, InputStream inputStream, FileBackedOutputStream fileBackedOutputStream, StorageObjectMetadata meta, String stageRegion) throws SnowflakeSQLException {
        ArrayList<FileInputStream> toClose = new ArrayList<FileInputStream>();
        Pair<InputStream, Boolean> uploadStreamInfo = this.createUploadStream(srcFile, uploadFromStream, inputStream, fileBackedOutputStream, toClose);
        if (!(meta instanceof AzureObjectMetadata)) {
            throw new IllegalArgumentException("Unexpected metadata object type");
        }
        int retryCount = 0;
        while (true) {
            try {
                logger.debug("Starting upload");
                InputStream fileInputStream = uploadStreamInfo.getLeft();
                CloudBlobContainer container = this.azStorageClient.getContainerReference(remoteStorageLocation);
                CloudBlockBlob blob = container.getBlockBlobReference(destFileName);
                blob.setMetadata((HashMap)meta.getUserMetadata());
                blob.upload(fileInputStream, -1L);
                logger.debug("Upload successful");
                for (FileInputStream is : toClose) {
                    IOUtils.closeQuietly(is);
                }
                return;
            }
            catch (Exception ex) {
                SnowflakeAzureClient.handleAzureException(ex, ++retryCount, "upload", connection, command, this);
                if (uploadFromStream && fileBackedOutputStream == null) {
                    throw new SnowflakeSQLException(ex, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), "Encountered exception during upload: " + ex.getMessage() + "\nCannot retry upload from stream.");
                }
                uploadStreamInfo = this.createUploadStream(srcFile, uploadFromStream, inputStream, fileBackedOutputStream, toClose);
                if (retryCount <= this.getMaxRetries()) continue;
                for (FileInputStream is : toClose) {
                    IOUtils.closeQuietly(is);
                }
                throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Unexpected: upload unsuccessful without exception!");
            }
            break;
        }
    }

    @Override
    public void handleStorageException(Exception ex, int retryCount, String operation, SFSession connection, String command) throws SnowflakeSQLException {
        SnowflakeAzureClient.handleAzureException(ex, retryCount, operation, connection, command, this);
    }

    private Pair<InputStream, Boolean> createUploadStream(File srcFile, boolean uploadFromStream, InputStream inputStream, FileBackedOutputStream fileBackedOutputStream, List<FileInputStream> toClose) throws SnowflakeSQLException {
        InputStream stream;
        logger.debug("createUploadStream({}, {}, {}, {}, {}, {})", this, srcFile, uploadFromStream, inputStream, fileBackedOutputStream, toClose);
        try {
            if (uploadFromStream) {
                stream = fileBackedOutputStream != null ? fileBackedOutputStream.asByteSource().openStream() : inputStream;
            } else {
                FileInputStream srcFileStream = new FileInputStream(srcFile);
                toClose.add(srcFileStream);
                stream = srcFileStream;
            }
        }
        catch (FileNotFoundException ex) {
            logger.error("Failed to open input file", ex);
            throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Failed to open input file", ex.getMessage());
        }
        catch (IOException ex) {
            logger.error("Failed to open input stream", ex);
            throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Failed to open input stream", ex.getMessage());
        }
        return new ImmutablePair<InputStream, Boolean>(stream, uploadFromStream);
    }

    private static void handleAzureException(Exception ex, int retryCount, String operation, SFSession connection, String command, SnowflakeAzureClient azClient) throws SnowflakeSQLException {
        if (ex.getCause() instanceof InvalidKeyException) {
            SnowflakeFileTransferAgent.throwJCEMissingError(operation, ex);
        }
        if (((StorageException)ex).getHttpStatusCode() == 403) {
            SnowflakeFileTransferAgent.renewExpiredToken(connection, command, azClient);
        }
        if (ex instanceof StorageException) {
            StorageException se = (StorageException)ex;
            if (retryCount > azClient.getMaxRetries()) {
                throw new SnowflakeSQLException(se, "58000", (int)ErrorCode.AZURE_SERVICE_ERROR.getMessageCode(), operation, se.getErrorCode(), se.getExtendedErrorInformation(), se.getHttpStatusCode(), se.getMessage());
            }
            logger.debug("Encountered exception ({}) during {}, retry count: {}", ex.getMessage(), operation, retryCount);
            logger.debug("Stack trace: ", ex);
            int backoffInMillis = azClient.getRetryBackoffMin();
            if (retryCount > 1) {
                backoffInMillis <<= Math.min(retryCount - 1, azClient.getRetryBackoffMaxExponent());
            }
            try {
                logger.debug("Sleep for {} milliseconds before retry", backoffInMillis);
                Thread.sleep(backoffInMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (se.getHttpStatusCode() == 403) {
                SnowflakeFileTransferAgent.renewExpiredToken(connection, command, azClient);
            }
        } else if (ex instanceof InterruptedException || SnowflakeUtil.getRootCause(ex) instanceof SocketTimeoutException) {
            if (retryCount > azClient.getMaxRetries()) {
                throw new SnowflakeSQLException(ex, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), "Encountered exception during " + operation + ": " + ex.getMessage());
            }
            logger.debug("Encountered exception ({}) during {}, retry count: {}", ex.getMessage(), operation, retryCount);
        } else {
            throw new SnowflakeSQLException(ex, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), "Encountered exception during " + operation + ": " + ex.getMessage());
        }
    }

    private static URI buildAzureStorageEndpointURI(String storageEndPoint, String storageAccount) throws URISyntaxException {
        URI storageEndpoint = new URI("https", storageAccount + "." + storageEndPoint + "/", null, null);
        return storageEndpoint;
    }
}

