/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.util.Iterator;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectSummary;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.UnsupportedOperationException;

public class AzureObjectSummariesIterator
implements Iterator<StorageObjectSummary> {
    Iterator<ListBlobItem> itemIterator;

    public AzureObjectSummariesIterator(Iterable<ListBlobItem> azCloudBlobIterable) {
        this.itemIterator = azCloudBlobIterable.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.itemIterator.hasNext();
    }

    @Override
    public StorageObjectSummary next() {
        ListBlobItem listBlobItem = this.itemIterator.next();
        if (!(listBlobItem instanceof CloudBlob)) {
            throw new IllegalArgumentException("Unexpected listBlobItem instace type");
        }
        return StorageObjectSummary.createFromAzureListBlobItem(listBlobItem);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method not supported");
    }
}

