/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds.internal.security.certprovider;

import java.util.LinkedHashMap;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.certprovider.CertificateProviderProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.certprovider.FileWatcherCertificateProviderProvider;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class CertificateProviderRegistry {
    private static CertificateProviderRegistry instance;
    private final LinkedHashMap<String, CertificateProviderProvider> providers = new LinkedHashMap();

    @VisibleForTesting
    public CertificateProviderRegistry() {
    }

    public static synchronized CertificateProviderRegistry getInstance() {
        if (instance == null) {
            instance = new CertificateProviderRegistry();
            instance.register(new FileWatcherCertificateProviderProvider());
        }
        return instance;
    }

    public synchronized void register(CertificateProviderProvider certificateProviderProvider) {
        Preconditions.checkNotNull(certificateProviderProvider, "certificateProviderProvider");
        this.providers.put(certificateProviderProvider.getName(), certificateProviderProvider);
    }

    public synchronized void deregister(CertificateProviderProvider certificateProviderProvider) {
        Preconditions.checkNotNull(certificateProviderProvider, "certificateProviderProvider");
        this.providers.remove(certificateProviderProvider.getName());
    }

    @Nullable
    synchronized CertificateProviderProvider getProvider(String name) {
        return this.providers.get(Preconditions.checkNotNull(name, "name"));
    }
}

