/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds.internal.security.certprovider;

import java.util.Map;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.Internal;
import net.snowflake.client.jdbc.internal.grpc.xds.Bootstrapper;
import net.snowflake.client.jdbc.internal.grpc.xds.EnvoyServerProtoData;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.SslContextProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.certprovider.CertProviderServerSslContextProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.certprovider.CertProviderSslContextProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.certprovider.CertificateProviderStore;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Node;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

@Internal
public final class CertProviderServerSslContextProviderFactory {
    private static final CertProviderServerSslContextProviderFactory DEFAULT_INSTANCE = new CertProviderServerSslContextProviderFactory(CertificateProviderStore.getInstance());
    private final CertificateProviderStore certificateProviderStore;

    @VisibleForTesting
    public CertProviderServerSslContextProviderFactory(CertificateProviderStore certificateProviderStore) {
        this.certificateProviderStore = certificateProviderStore;
    }

    public static CertProviderServerSslContextProviderFactory getInstance() {
        return DEFAULT_INSTANCE;
    }

    public SslContextProvider getProvider(EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext, Node node, @Nullable Map<String, Bootstrapper.CertificateProviderInfo> certProviders) {
        Preconditions.checkNotNull(downstreamTlsContext, "downstreamTlsContext");
        CommonTlsContext commonTlsContext = downstreamTlsContext.getCommonTlsContext();
        CertificateValidationContext staticCertValidationContext = CertProviderSslContextProvider.getStaticValidationContext(commonTlsContext);
        CommonTlsContext.CertificateProviderInstance rootCertInstance = CertProviderSslContextProvider.getRootCertProviderInstance(commonTlsContext);
        CommonTlsContext.CertificateProviderInstance certInstance = CertProviderSslContextProvider.getCertProviderInstance(commonTlsContext);
        return new CertProviderServerSslContextProvider(node, certProviders, certInstance, rootCertInstance, staticCertValidationContext, downstreamTlsContext, this.certificateProviderStore);
    }
}

