/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.alts;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.jdbc.internal.grpc.BindableService;
import net.snowflake.client.jdbc.internal.grpc.CompressorRegistry;
import net.snowflake.client.jdbc.internal.grpc.DecompressorRegistry;
import net.snowflake.client.jdbc.internal.grpc.ExperimentalApi;
import net.snowflake.client.jdbc.internal.grpc.ForwardingServerBuilder;
import net.snowflake.client.jdbc.internal.grpc.HandlerRegistry;
import net.snowflake.client.jdbc.internal.grpc.Server;
import net.snowflake.client.jdbc.internal.grpc.ServerBuilder;
import net.snowflake.client.jdbc.internal.grpc.ServerInterceptor;
import net.snowflake.client.jdbc.internal.grpc.ServerServiceDefinition;
import net.snowflake.client.jdbc.internal.grpc.ServerStreamTracer;
import net.snowflake.client.jdbc.internal.grpc.ServerTransportFilter;
import net.snowflake.client.jdbc.internal.grpc.alts.AltsServerCredentials;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4151")
public final class AltsServerBuilder
extends ForwardingServerBuilder<AltsServerBuilder> {
    private final NettyServerBuilder delegate;
    private final AltsServerCredentials.Builder credentialsBuilder = new AltsServerCredentials.Builder();

    private AltsServerBuilder(NettyServerBuilder nettyDelegate) {
        this.delegate = nettyDelegate;
    }

    public static AltsServerBuilder forPort(int port) {
        NettyServerBuilder nettyDelegate = NettyServerBuilder.forAddress(new InetSocketAddress(port));
        return new AltsServerBuilder(nettyDelegate);
    }

    public AltsServerBuilder enableUntrustedAltsForTesting() {
        this.credentialsBuilder.enableUntrustedAltsForTesting();
        return this;
    }

    public AltsServerBuilder setHandshakerAddressForTesting(String handshakerAddress) {
        this.credentialsBuilder.setHandshakerAddressForTesting(handshakerAddress);
        return this;
    }

    @Override
    protected ServerBuilder<?> delegate() {
        return this.delegate;
    }

    @Override
    public AltsServerBuilder handshakeTimeout(long timeout, TimeUnit unit) {
        this.delegate.handshakeTimeout(timeout, unit);
        return this;
    }

    @Override
    public AltsServerBuilder directExecutor() {
        this.delegate.directExecutor();
        return this;
    }

    @Override
    public AltsServerBuilder addStreamTracerFactory(ServerStreamTracer.Factory factory) {
        this.delegate.addStreamTracerFactory(factory);
        return this;
    }

    @Override
    public AltsServerBuilder addTransportFilter(ServerTransportFilter filter) {
        this.delegate.addTransportFilter(filter);
        return this;
    }

    @Override
    public AltsServerBuilder executor(Executor executor) {
        this.delegate.executor(executor);
        return this;
    }

    @Override
    public AltsServerBuilder addService(ServerServiceDefinition service) {
        this.delegate.addService(service);
        return this;
    }

    @Override
    public AltsServerBuilder addService(BindableService bindableService) {
        this.delegate.addService(bindableService);
        return this;
    }

    @Override
    public AltsServerBuilder fallbackHandlerRegistry(HandlerRegistry fallbackRegistry) {
        this.delegate.fallbackHandlerRegistry(fallbackRegistry);
        return this;
    }

    @Override
    public AltsServerBuilder useTransportSecurity(File certChain, File privateKey) {
        throw new UnsupportedOperationException("Can't set TLS settings for ALTS");
    }

    @Override
    public AltsServerBuilder decompressorRegistry(DecompressorRegistry registry) {
        this.delegate.decompressorRegistry(registry);
        return this;
    }

    @Override
    public AltsServerBuilder compressorRegistry(CompressorRegistry registry) {
        this.delegate.compressorRegistry(registry);
        return this;
    }

    @Override
    public AltsServerBuilder intercept(ServerInterceptor interceptor) {
        this.delegate.intercept(interceptor);
        return this;
    }

    @Override
    public Server build() {
        this.delegate.protocolNegotiator(this.credentialsBuilder.buildProtocolNegotiator());
        return this.delegate.build();
    }
}

