/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Buffers;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ByteStringStrategy;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Crc32cValue;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Hasher;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.protobuf.ByteString;
import net.snowflake.client.jdbc.internal.org.checkerframework.checker.nullness.qual.Nullable;

final class ChunkSegmenter {
    private final Hasher hasher;
    private final ByteStringStrategy bss;
    private final int maxSegmentSize;
    private final int blockSize;

    ChunkSegmenter(Hasher hasher, ByteStringStrategy bss, int maxSegmentSize) {
        this(hasher, bss, maxSegmentSize, 262144);
    }

    @VisibleForTesting
    ChunkSegmenter(Hasher hasher, ByteStringStrategy bss, int maxSegmentSize, int blockSize) {
        this.hasher = hasher;
        this.bss = bss;
        this.maxSegmentSize = maxSegmentSize;
        this.blockSize = blockSize;
    }

    Hasher getHasher() {
        return this.hasher;
    }

    ChunkSegment[] segmentBuffers(ByteBuffer[] bbs) {
        return this.segmentBuffers(bbs, 0, bbs.length);
    }

    ChunkSegment[] segmentBuffers(ByteBuffer[] bbs, int offset, int length) {
        ArrayDeque<ChunkSegment> data = new ArrayDeque<ChunkSegment>();
        for (int i = offset; i < length; ++i) {
            int remaining;
            ByteBuffer buffer = bbs[i];
            while ((remaining = buffer.remaining()) > 0) {
                ChunkSegment peekLast = (ChunkSegment)data.peekLast();
                if (peekLast == null || peekLast.b.size() == this.maxSegmentSize) {
                    int limit = Math.min(remaining, this.maxSegmentSize);
                    ChunkSegment datum = this.newSegment(buffer, limit);
                    data.addLast(datum);
                    continue;
                }
                ChunkSegment chunkSoFar = (ChunkSegment)data.pollLast();
                int limit = Math.min(remaining, this.maxSegmentSize - chunkSoFar.b.size());
                ChunkSegment datum = this.newSegment(buffer, limit);
                ChunkSegment plus = chunkSoFar.concat(datum);
                data.addLast(plus);
            }
        }
        return data.toArray(new ChunkSegment[0]);
    }

    private ChunkSegment newSegment(ByteBuffer buffer, int limit) {
        ByteBuffer slice = buffer.slice();
        slice.limit(limit);
        Crc32cValue.Crc32cLengthKnown hash = this.hasher.hash(slice::duplicate);
        ByteString byteString = (ByteString)this.bss.apply(slice);
        Buffers.position(buffer, buffer.position() + limit);
        return new ChunkSegment(byteString, hash);
    }

    final class ChunkSegment {
        private final ByteString b;
        private final  @Nullable Crc32cValue.Crc32cLengthKnown crc32c;
        private final boolean onlyFullBlocks;

        private ChunkSegment(@Nullable ByteString b, Crc32cValue.Crc32cLengthKnown crc32c) {
            this.b = b;
            this.onlyFullBlocks = b.size() % ChunkSegmenter.this.blockSize == 0;
            this.crc32c = crc32c;
        }

        public ChunkSegment concat(ChunkSegment other) {
            Crc32cValue.Crc32cLengthKnown newCrc = null;
            if (this.crc32c != null && other.crc32c != null) {
                newCrc = this.crc32c.concat(other.crc32c);
            }
            ByteString concat = this.b.concat(other.b);
            return new ChunkSegment(concat, newCrc);
        }

        public ByteString getB() {
            return this.b;
        }

        public  @Nullable Crc32cValue.Crc32cLengthKnown getCrc32c() {
            return this.crc32c;
        }

        public boolean isOnlyFullBlocks() {
            return this.onlyFullBlocks;
        }
    }
}

