/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto;

import java.security.interfaces.RSAPublicKey;
import javax.crypto.SecretKey;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.EncryptionMethod;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWEAlgorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWECryptoParts;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWEEncrypter;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWEHeader;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.AAD;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.JWEHeaderValidation;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.RSA1_5;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.RSACryptoProvider;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.RSA_OAEP;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.RSA_OAEP_SHA2;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.RSAKey;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.Base64URL;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RSAEncrypter
extends RSACryptoProvider
implements JWEEncrypter {
    private final RSAPublicKey publicKey;

    public RSAEncrypter(RSAPublicKey publicKey) {
        this(publicKey, null);
    }

    public RSAEncrypter(RSAKey rsaJWK) throws JOSEException {
        this(rsaJWK.toRSAPublicKey());
    }

    public RSAEncrypter(RSAPublicKey publicKey, SecretKey contentEncryptionKey) {
        super(contentEncryptionKey);
        if (publicKey == null) {
            throw new IllegalArgumentException("The public RSA key must not be null");
        }
        this.publicKey = publicKey;
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    @Deprecated
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText) throws JOSEException {
        return this.encrypt(header, clearText, AAD.compute(header));
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText, byte[] aad) throws JOSEException {
        Base64URL encryptedKey;
        JWEAlgorithm alg = JWEHeaderValidation.getAlgorithmAndEnsureNotNull(header);
        EncryptionMethod enc = header.getEncryptionMethod();
        SecretKey cek = this.getCEK(enc);
        if (alg.equals(JWEAlgorithm.RSA1_5)) {
            encryptedKey = Base64URL.encode(RSA1_5.encryptCEK(this.publicKey, cek, this.getJCAContext().getKeyEncryptionProvider()));
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP)) {
            encryptedKey = Base64URL.encode(RSA_OAEP.encryptCEK(this.publicKey, cek, this.getJCAContext().getKeyEncryptionProvider()));
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP_256)) {
            encryptedKey = Base64URL.encode(RSA_OAEP_SHA2.encryptCEK(this.publicKey, cek, 256, this.getJCAContext().getKeyEncryptionProvider()));
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP_384)) {
            encryptedKey = Base64URL.encode(RSA_OAEP_SHA2.encryptCEK(this.publicKey, cek, 384, this.getJCAContext().getKeyEncryptionProvider()));
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP_512)) {
            encryptedKey = Base64URL.encode(RSA_OAEP_SHA2.encryptCEK(this.publicKey, cek, 512, this.getJCAContext().getKeyEncryptionProvider()));
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(alg, SUPPORTED_ALGORITHMS));
        }
        return ContentCryptoProvider.encrypt(header, clearText, aad, cek, encryptedKey, this.getJCAContext());
    }
}

