/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.snowflake.client.core.BaseSqlInput;
import net.snowflake.client.core.ColumnTypeHelper;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFResultSet;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.SqlInputTimestampUtil;
import net.snowflake.client.core.json.Converters;
import net.snowflake.client.core.structs.SQLDataCreationHelper;
import net.snowflake.client.jdbc.FieldMetadata;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.type.TypeReference;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTimestamp;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SnowflakeDateTimeFormat;
import net.snowflake.client.util.ThrowingTriFunction;

@SnowflakeJdbcInternalApi
public class JsonSqlInput
extends BaseSqlInput {
    private final JsonNode input;
    private final Iterator<JsonNode> elements;
    private final TimeZone sessionTimeZone;
    private int currentIndex = 0;
    private boolean wasNull = false;

    public JsonSqlInput(JsonNode input, SFBaseSession session, Converters converters, List<FieldMetadata> fields, TimeZone sessionTimeZone) {
        super(session, converters, fields);
        this.input = input;
        this.elements = input.elements();
        this.sessionTimeZone = sessionTimeZone;
    }

    public JsonNode getInput() {
        return this.input;
    }

    @Override
    public String readString() throws SQLException {
        return this.withNextValue((value, jsonNode, fieldMetadata) -> {
            int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
            int columnSubType = fieldMetadata.getType();
            int scale = fieldMetadata.getScale();
            return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getStringConverter().getString(value, columnType, columnSubType, scale));
        });
    }

    @Override
    public boolean readBoolean() throws SQLException {
        return this.withNextValue((value, jsonNode, fieldMetadata) -> {
            int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
            return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getBooleanConverter().getBoolean(value, columnType));
        });
    }

    @Override
    public byte readByte() throws SQLException {
        return this.withNextValue((value, jsonNode, fieldMetadata) -> SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getNumberConverter().getByte(value)));
    }

    @Override
    public short readShort() throws SQLException {
        return this.withNextValue((value, jsonNode, fieldMetadata) -> {
            int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
            return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getNumberConverter().getShort(value, columnType));
        });
    }

    @Override
    public int readInt() throws SQLException {
        return this.withNextValue((value, jsonNode, fieldMetadata) -> {
            int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
            return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getNumberConverter().getInt(value, columnType));
        });
    }

    @Override
    public long readLong() throws SQLException {
        return this.withNextValue((value, jsonNode, fieldMetadata) -> {
            int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
            return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getNumberConverter().getLong(value, columnType));
        });
    }

    @Override
    public float readFloat() throws SQLException {
        return this.withNextValue((value, jsonNode, fieldMetadata) -> {
            int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
            return SnowflakeUtil.mapSFExceptionToSQLException(() -> Float.valueOf(this.converters.getNumberConverter().getFloat(value, columnType)));
        }).floatValue();
    }

    @Override
    public double readDouble() throws SQLException {
        return this.withNextValue((value, jsonNode, fieldMetadata) -> {
            int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
            return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getNumberConverter().getDouble(value, columnType));
        });
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        return this.withNextValue((value, jsonNode, fieldMetadata) -> this.convertBigDecimal(value, (FieldMetadata)fieldMetadata));
    }

    private BigDecimal convertBigDecimal(Object value, FieldMetadata fieldMetadata) throws SQLException {
        int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getNumberConverter().getBigDecimal(value, columnType));
    }

    @Override
    public byte[] readBytes() throws SQLException {
        return this.withNextValue((value, jsonNode, fieldMetadata) -> this.convertToBytes(value, (FieldMetadata)fieldMetadata));
    }

    private byte[] convertToBytes(Object value, FieldMetadata fieldMetadata) throws SQLException {
        int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
        int columnSubType = fieldMetadata.getType();
        int scale = fieldMetadata.getScale();
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getBytesConverter().getBytes(value, columnType, columnSubType, scale));
    }

    @Override
    public Date readDate() throws SQLException {
        return this.withNextValue((value, jsonNode, fieldMetadata) -> {
            if (value == null) {
                return null;
            }
            return this.formatDate((String)value);
        });
    }

    private Date formatDate(String value) {
        SnowflakeDateTimeFormat formatter = JsonSqlInput.getFormat(this.session, "DATE_OUTPUT_FORMAT");
        SFTimestamp timestamp = formatter.parse(value);
        return Date.valueOf(Instant.ofEpochMilli(timestamp.getTime()).atZone(ZoneOffset.UTC).toLocalDate());
    }

    @Override
    public Time readTime() throws SQLException {
        return this.withNextValue((value, jsonNode, fieldMetadata) -> {
            if (value == null) {
                return null;
            }
            return this.formatTime((String)value);
        });
    }

    private Time formatTime(String value) {
        SnowflakeDateTimeFormat formatter = JsonSqlInput.getFormat(this.session, "TIME_OUTPUT_FORMAT");
        SFTimestamp timestamp = formatter.parse(value);
        return Time.valueOf(Instant.ofEpochMilli(timestamp.getTime()).atZone(ZoneOffset.UTC).toLocalTime());
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        return this.readTimestamp(null);
    }

    @Override
    public Timestamp readTimestamp(TimeZone tz) throws SQLException {
        return this.withNextValue((value, jsonNode, fieldMetadata) -> {
            if (value == null) {
                return null;
            }
            return this.formatTimestamp(tz, value, (FieldMetadata)fieldMetadata);
        });
    }

    @Override
    public <T> T readObject(Class<T> type) throws SQLException {
        return (T)this.withNextValue((value, jsonNode, fieldMetadata) -> {
            if (SQLData.class.isAssignableFrom(type)) {
                if (jsonNode.isNull()) {
                    return null;
                }
                JsonSqlInput sqlInput = new JsonSqlInput((JsonNode)jsonNode, this.session, this.converters, fieldMetadata.getFields(), this.sessionTimeZone);
                SQLData instance = (SQLData)SQLDataCreationHelper.create(type);
                instance.readSQL(sqlInput, null);
                return instance;
            }
            if (Map.class.isAssignableFrom(type)) {
                if (value == null) {
                    return null;
                }
                return this.convertSqlInputToMap((SQLInput)value);
            }
            if (value == null) {
                return null;
            }
            if (String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Byte.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type)) {
                return value;
            }
            if (Date.class.isAssignableFrom(type)) {
                return this.formatDate((String)value);
            }
            if (Time.class.isAssignableFrom(type)) {
                return this.formatTime((String)value);
            }
            if (Timestamp.class.isAssignableFrom(type)) {
                return this.formatTimestamp(this.sessionTimeZone, value, (FieldMetadata)fieldMetadata);
            }
            if (Byte[].class.isAssignableFrom(type)) {
                return this.convertToBytes(value, (FieldMetadata)fieldMetadata);
            }
            if (BigDecimal.class.isAssignableFrom(type)) {
                return this.convertBigDecimal(value, (FieldMetadata)fieldMetadata);
            }
            SFResultSet.logger.debug("Unsupported type passed to readObject(int columnIndex,Class<T> type): " + type.getName(), new Object[0]);
            throw new SQLException("Type passed to 'getObject(int columnIndex,Class<T> type)' is unsupported. Type: " + type.getName());
        });
    }

    private Timestamp formatTimestamp(TimeZone tz, Object value, FieldMetadata fieldMetadata) throws SQLException {
        if (value == null) {
            return null;
        }
        int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
        int columnSubType = fieldMetadata.getType();
        int scale = fieldMetadata.getScale();
        Timestamp result = SqlInputTimestampUtil.getTimestampFromType(columnSubType, (String)value, this.session, this.sessionTimeZone, tz);
        if (result != null) {
            return result;
        }
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getDateTimeConverter().getTimestamp(value, columnType, columnSubType, tz, scale));
    }

    @Override
    public Object readObject() throws SQLException {
        return this.withNextValue((value, jsonNode, fieldMetadata) -> value);
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    Map<String, Object> convertSqlInputToMap(SQLInput sqlInput) {
        return SFBaseResultSet.OBJECT_MAPPER.convertValue((Object)((JsonSqlInput)sqlInput).getInput(), new TypeReference<Map<String, Object>>(){});
    }

    private <T> T withNextValue(ThrowingTriFunction<Object, JsonNode, FieldMetadata, T, SQLException> action) throws SQLException {
        JsonNode jsonNode = this.elements.next();
        Object value = this.getValue(jsonNode);
        this.wasNull = value == null;
        return action.apply(value, jsonNode, (FieldMetadata)this.fields.get(this.currentIndex++));
    }

    private Object getValue(JsonNode jsonNode) {
        if (jsonNode.isTextual()) {
            return jsonNode.textValue();
        }
        if (jsonNode.isBoolean()) {
            return jsonNode.booleanValue();
        }
        if (jsonNode.isNumber()) {
            return jsonNode.numberValue();
        }
        return null;
    }

    private static SnowflakeDateTimeFormat getFormat(SFBaseSession session, String format) {
        return SnowflakeDateTimeFormat.fromSqlFormat((String)session.getCommonParameters().get(format));
    }
}

