/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its;

import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Object;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Primitive;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Sequence;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.EncryptedDataEncryptionKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.HashedId;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.Utils;

public class PKRecipientInfo
extends ASN1Object {
    private final HashedId recipientId;
    private final EncryptedDataEncryptionKey encKey;

    public PKRecipientInfo(HashedId hashedId, EncryptedDataEncryptionKey encryptedDataEncryptionKey) {
        this.recipientId = hashedId;
        this.encKey = encryptedDataEncryptionKey;
    }

    public static PKRecipientInfo getInstance(Object object) {
        if (object instanceof PKRecipientInfo) {
            return (PKRecipientInfo)object;
        }
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(object);
        return new PKRecipientInfo(HashedId.getInstance(aSN1Sequence.getObjectAt(0)), EncryptedDataEncryptionKey.getInstance(aSN1Sequence.getObjectAt(0)));
    }

    public HashedId getRecipientId() {
        return this.recipientId;
    }

    public EncryptedDataEncryptionKey getEncKey() {
        return this.encKey;
    }

    public ASN1Primitive toASN1Primitive() {
        return Utils.toSequence(this.recipientId, this.encKey);
    }

    public static class Builder {
        private HashedId recipientId;
        private EncryptedDataEncryptionKey encKey;

        public Builder setRecipientId(HashedId hashedId) {
            this.recipientId = hashedId;
            return this;
        }

        public Builder setEncKey(EncryptedDataEncryptionKey encryptedDataEncryptionKey) {
            this.encKey = encryptedDataEncryptionKey;
            return this;
        }

        public PKRecipientInfo createPKRecipientInfo() {
            return new PKRecipientInfo(this.recipientId, this.encKey);
        }
    }
}

