/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.http.impl.entity;

import net.snowflake.client.jdbc.internal.apache.http.Header;
import net.snowflake.client.jdbc.internal.apache.http.HeaderElement;
import net.snowflake.client.jdbc.internal.apache.http.HttpException;
import net.snowflake.client.jdbc.internal.apache.http.HttpMessage;
import net.snowflake.client.jdbc.internal.apache.http.ParseException;
import net.snowflake.client.jdbc.internal.apache.http.ProtocolException;
import net.snowflake.client.jdbc.internal.apache.http.annotation.Contract;
import net.snowflake.client.jdbc.internal.apache.http.annotation.ThreadingBehavior;
import net.snowflake.client.jdbc.internal.apache.http.entity.ContentLengthStrategy;
import net.snowflake.client.jdbc.internal.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class LaxContentLengthStrategy
implements ContentLengthStrategy {
    public static final LaxContentLengthStrategy INSTANCE = new LaxContentLengthStrategy();
    private final int implicitLen;

    public LaxContentLengthStrategy(int implicitLen) {
        this.implicitLen = implicitLen;
    }

    public LaxContentLengthStrategy() {
        this(-1);
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        Args.notNull(message, "HTTP message");
        Header transferEncodingHeader = message.getFirstHeader("Transfer-Encoding");
        if (transferEncodingHeader != null) {
            HeaderElement[] encodings;
            try {
                encodings = transferEncodingHeader.getElements();
            }
            catch (ParseException px) {
                throw new ProtocolException("Invalid Transfer-Encoding header value: " + transferEncodingHeader, px);
            }
            int len = encodings.length;
            if ("identity".equalsIgnoreCase(transferEncodingHeader.getValue())) {
                return -1L;
            }
            if (len > 0 && "chunked".equalsIgnoreCase(encodings[len - 1].getName())) {
                return -2L;
            }
            return -1L;
        }
        Header contentLengthHeader = message.getFirstHeader("Content-Length");
        if (contentLengthHeader != null) {
            long contentLen = -1L;
            Header[] headers = message.getHeaders("Content-Length");
            for (int i = headers.length - 1; i >= 0; --i) {
                Header header = headers[i];
                try {
                    contentLen = Long.parseLong(header.getValue());
                    break;
                }
                catch (NumberFormatException ignore) {
                    continue;
                }
            }
            return contentLen >= 0L ? contentLen : -1L;
        }
        return this.implicitLen;
    }
}

