/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.snowflake.common.util;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class StringUtil {
    public static Pattern octalCode = Pattern.compile("^\\\\0*(([0-7])|([0-7][0-7])|([0-3][0-7][0-7]))$");
    static Map<String, String> escapeSequenceToCharMap = new HashMap<String, String>();

    public static String checkAndConvertOctalToChar(String value) {
        if (octalCode.matcher(value).matches()) {
            try {
                return StringUtil.convertOctalToChar(value);
            }
            catch (NumberFormatException ex) {
                return value;
            }
        }
        return value;
    }

    public static String convertOctalToChar(String value) {
        if (value.startsWith("\\")) {
            value = value.substring(1);
        }
        Integer valueInDecimal = Integer.parseInt(value, 8);
        char valueInChar = (char)valueInDecimal.intValue();
        return String.valueOf(valueInChar);
    }

    public static String convertHexToChar(String value) {
        if (value.toLowerCase().startsWith("0x")) {
            value = value.substring(2);
        }
        Integer valueInDecimal = Integer.parseInt(value, 16);
        char valueInChar = (char)valueInDecimal.intValue();
        return String.valueOf(valueInChar);
    }

    public static String convertEscapedSequenceToChar(String value) {
        return escapeSequenceToCharMap.get(value);
    }

    public static String quote(String str) {
        if (str.contains("\"")) {
            return '\"' + str + '\"';
        }
        return str;
    }

    public static boolean isPureAscii(String s2) {
        CharsetEncoder asciiEncode = Charset.forName("US-ASCII").newEncoder();
        return asciiEncode.canEncode(s2);
    }

    public static boolean isAlphaNumericUnderscore(String sequence) {
        return sequence.matches("[A-Za-z0-9_]+");
    }

    static {
        escapeSequenceToCharMap.put("\\\"", String.valueOf('\"'));
        escapeSequenceToCharMap.put("\\0", String.valueOf('\u0000'));
        escapeSequenceToCharMap.put("\\f", String.valueOf('\f'));
        escapeSequenceToCharMap.put("\\t", String.valueOf('\t'));
        escapeSequenceToCharMap.put("\\n", String.valueOf('\n'));
        escapeSequenceToCharMap.put("\\r", String.valueOf('\r'));
        escapeSequenceToCharMap.put("\\\\", String.valueOf('\\'));
    }
}

