/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.its.bc;

import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Encodable;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.nist.NISTNamedCurves;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x9.X9ECParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.params.ECDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.its.ITSPublicVerificationKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECCurve;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECPoint;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.EccCurvePoint;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.EccP256CurvePoint;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.EccP384CurvePoint;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.PublicVerificationKey;

public class BcITSPublicVerificationKey
extends ITSPublicVerificationKey {
    public BcITSPublicVerificationKey(PublicVerificationKey publicVerificationKey) {
        super(publicVerificationKey);
    }

    static PublicVerificationKey fromKeyParameters(ECPublicKeyParameters eCPublicKeyParameters) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = ((ECNamedDomainParameters)eCPublicKeyParameters.getParameters()).getName();
        ECPoint eCPoint = eCPublicKeyParameters.getQ();
        if (aSN1ObjectIdentifier.equals(SECObjectIdentifiers.secp256r1)) {
            return new PublicVerificationKey(0, EccP256CurvePoint.builder().createUncompressedP256(eCPoint.getAffineXCoord().toBigInteger(), eCPoint.getAffineYCoord().toBigInteger()));
        }
        if (aSN1ObjectIdentifier.equals(TeleTrusTObjectIdentifiers.brainpoolP256r1)) {
            return new PublicVerificationKey(1, EccP256CurvePoint.builder().createUncompressedP256(eCPoint.getAffineXCoord().toBigInteger(), eCPoint.getAffineYCoord().toBigInteger()));
        }
        if (aSN1ObjectIdentifier.equals(TeleTrusTObjectIdentifiers.brainpoolP384r1)) {
            return new PublicVerificationKey(3, EccP384CurvePoint.builder().createUncompressedP384(eCPoint.getAffineXCoord().toBigInteger(), eCPoint.getAffineYCoord().toBigInteger()));
        }
        throw new IllegalArgumentException("unknown curve in public encryption key");
    }

    public BcITSPublicVerificationKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        super(BcITSPublicVerificationKey.fromKeyParameters((ECPublicKeyParameters)asymmetricKeyParameter));
    }

    public AsymmetricKeyParameter getKey() {
        byte[] byArray;
        X9ECParameters x9ECParameters;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        switch (this.verificationKey.getChoice()) {
            case 0: {
                aSN1ObjectIdentifier = SECObjectIdentifiers.secp256r1;
                x9ECParameters = NISTNamedCurves.getByOID(SECObjectIdentifiers.secp256r1);
                break;
            }
            case 1: {
                aSN1ObjectIdentifier = TeleTrusTObjectIdentifiers.brainpoolP256r1;
                x9ECParameters = TeleTrusTNamedCurves.getByOID(TeleTrusTObjectIdentifiers.brainpoolP256r1);
                break;
            }
            case 3: {
                aSN1ObjectIdentifier = TeleTrusTObjectIdentifiers.brainpoolP384r1;
                x9ECParameters = TeleTrusTNamedCurves.getByOID(TeleTrusTObjectIdentifiers.brainpoolP384r1);
                break;
            }
            default: {
                throw new IllegalStateException("unknown key type");
            }
        }
        ECCurve eCCurve = x9ECParameters.getCurve();
        ASN1Encodable aSN1Encodable = this.verificationKey.getCurvePoint();
        if (!(aSN1Encodable instanceof EccCurvePoint)) {
            throw new IllegalStateException("extension to public verification key not supported");
        }
        EccCurvePoint eccCurvePoint = (EccCurvePoint)this.verificationKey.getCurvePoint();
        if (eccCurvePoint instanceof EccP256CurvePoint) {
            byArray = eccCurvePoint.getEncodedPoint();
        } else if (eccCurvePoint instanceof EccP384CurvePoint) {
            byArray = eccCurvePoint.getEncodedPoint();
        } else {
            throw new IllegalStateException("unknown key type");
        }
        ECPoint eCPoint = eCCurve.decodePoint(byArray).normalize();
        return new ECPublicKeyParameters(eCPoint, (ECDomainParameters)new ECNamedDomainParameters(aSN1ObjectIdentifier, x9ECParameters));
    }
}

