/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

public class BitToBooleanConverter
extends AbstractArrowVectorConverter {
    private BitVector bitVector;

    public BitToBooleanConverter(ValueVector fieldVector, int columnIndex, DataConversionContext context) {
        super(SnowflakeType.BOOLEAN.name(), fieldVector, columnIndex, context);
        this.bitVector = (BitVector)fieldVector;
    }

    private int getBit(int index) {
        int byteIndex = index >> 3;
        byte b = this.bitVector.getDataBuffer().getByte(byteIndex);
        int bitIndex = index & 7;
        return b >> bitIndex & 1;
    }

    @Override
    public boolean toBoolean(int index) {
        if (this.isNull(index)) {
            return false;
        }
        return this.getBit(index) != 0;
    }

    @Override
    public byte[] toBytes(int index) {
        if (this.isNull(index)) {
            return null;
        }
        if (this.toBoolean(index)) {
            return new byte[]{1};
        }
        return new byte[]{0};
    }

    @Override
    public Object toObject(int index) {
        return this.isNull(index) ? null : Boolean.valueOf(this.toBoolean(index));
    }

    @Override
    public String toString(int index) {
        return this.isNull(index) ? null : (this.toBoolean(index) ? "TRUE" : "FALSE");
    }

    @Override
    public short toShort(int rowIndex) throws SFException {
        return (short)(this.toBoolean(rowIndex) ? 1 : 0);
    }

    @Override
    public int toInt(int rowIndex) throws SFException {
        return this.toBoolean(rowIndex) ? 1 : 0;
    }

    @Override
    public long toLong(int rowIndex) throws SFException {
        return this.toBoolean(rowIndex) ? 1L : 0L;
    }

    @Override
    public float toFloat(int rowIndex) throws SFException {
        return this.toBoolean(rowIndex) ? 1.0f : 0.0f;
    }

    @Override
    public double toDouble(int rowIndex) throws SFException {
        return this.toBoolean(rowIndex) ? 1.0 : 0.0;
    }

    @Override
    public BigDecimal toBigDecimal(int rowIndex) throws SFException {
        return this.isNull(rowIndex) ? null : (this.toBoolean(rowIndex) ? BigDecimal.ONE : BigDecimal.ZERO);
    }
}

