/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.impl;

import java.io.IOException;
import java.util.Collection;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerationException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerator;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.BeanProperty;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonMappingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializationFeature;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializerProvider;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.AnnotatedMember;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.TypeSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.ContextualSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.std.StaticListSerializerBase;

@JacksonStdImpl
public class StringCollectionSerializer
extends StaticListSerializerBase<Collection<String>>
implements ContextualSerializer {
    public static final StringCollectionSerializer instance = new StringCollectionSerializer();
    protected final JsonSerializer<String> _serializer;

    protected StringCollectionSerializer() {
        this((JsonSerializer<?>)null);
    }

    protected StringCollectionSerializer(JsonSerializer<?> jsonSerializer) {
        super(Collection.class);
        this._serializer = jsonSerializer;
    }

    @Override
    protected JsonNode contentSchema() {
        return this.createSchemaNode("string", true);
    }

    @Override
    protected void acceptContentVisitor(JsonArrayFormatVisitor jsonArrayFormatVisitor) throws JsonMappingException {
        jsonArrayFormatVisitor.itemsFormat(JsonFormatTypes.STRING);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        Object object;
        AnnotatedMember annotatedMember;
        JsonSerializer<Object> jsonSerializer = null;
        if (beanProperty != null && (annotatedMember = beanProperty.getMember()) != null && (object = serializerProvider.getAnnotationIntrospector().findContentSerializer(annotatedMember)) != null) {
            jsonSerializer = serializerProvider.serializerInstance(annotatedMember, object);
        }
        if (jsonSerializer == null) {
            jsonSerializer = this._serializer;
        }
        if (this.isDefaultSerializer(jsonSerializer = (jsonSerializer = this.findConvertingContentSerializer(serializerProvider, beanProperty, jsonSerializer)) == null ? serializerProvider.findValueSerializer(String.class, beanProperty) : serializerProvider.handleSecondaryContextualization(jsonSerializer, beanProperty))) {
            jsonSerializer = null;
        }
        if (jsonSerializer == this._serializer) {
            return this;
        }
        return new StringCollectionSerializer(jsonSerializer);
    }

    @Override
    public void serialize(Collection<String> collection, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (collection.size() == 1 && serializerProvider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED)) {
            this._serializeUnwrapped(collection, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray();
        if (this._serializer == null) {
            this.serializeContents(collection, jsonGenerator, serializerProvider);
        } else {
            this.serializeUsingCustom(collection, jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndArray();
    }

    private final void _serializeUnwrapped(Collection<String> collection, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (this._serializer == null) {
            this.serializeContents(collection, jsonGenerator, serializerProvider);
        } else {
            this.serializeUsingCustom(collection, jsonGenerator, serializerProvider);
        }
    }

    @Override
    public void serializeWithType(Collection<String> collection, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
        typeSerializer.writeTypePrefixForArray(collection, jsonGenerator);
        if (this._serializer == null) {
            this.serializeContents(collection, jsonGenerator, serializerProvider);
        } else {
            this.serializeUsingCustom(collection, jsonGenerator, serializerProvider);
        }
        typeSerializer.writeTypeSuffixForArray(collection, jsonGenerator);
    }

    private final void serializeContents(Collection<String> collection, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (this._serializer != null) {
            this.serializeUsingCustom(collection, jsonGenerator, serializerProvider);
            return;
        }
        int n = 0;
        for (String string : collection) {
            try {
                if (string == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                } else {
                    jsonGenerator.writeString(string);
                }
                ++n;
            }
            catch (Exception exception) {
                this.wrapAndThrow(serializerProvider, (Throwable)exception, collection, n);
            }
        }
    }

    private void serializeUsingCustom(Collection<String> collection, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        JsonSerializer<String> jsonSerializer = this._serializer;
        int n = 0;
        for (String string : collection) {
            try {
                if (string == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                jsonSerializer.serialize(string, jsonGenerator, serializerProvider);
            }
            catch (Exception exception) {
                this.wrapAndThrow(serializerProvider, (Throwable)exception, collection, n);
            }
        }
    }
}

