/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.impl;

import java.io.IOException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerationException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerator;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonMappingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializationFeature;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializerProvider;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.TypeSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.NameTransformer;

public class BeanAsArraySerializer
extends BeanSerializerBase {
    protected final BeanSerializerBase _defaultSerializer;

    public BeanAsArraySerializer(BeanSerializerBase beanSerializerBase) {
        super(beanSerializerBase, (ObjectIdWriter)null);
        this._defaultSerializer = beanSerializerBase;
    }

    protected BeanAsArraySerializer(BeanSerializerBase beanSerializerBase, String[] stringArray) {
        super(beanSerializerBase, stringArray);
        this._defaultSerializer = beanSerializerBase;
    }

    protected BeanAsArraySerializer(BeanSerializerBase beanSerializerBase, ObjectIdWriter objectIdWriter, Object object) {
        super(beanSerializerBase, objectIdWriter, object);
        this._defaultSerializer = beanSerializerBase;
    }

    @Override
    public JsonSerializer<Object> unwrappingSerializer(NameTransformer nameTransformer) {
        return this._defaultSerializer.unwrappingSerializer(nameTransformer);
    }

    @Override
    public boolean isUnwrappingSerializer() {
        return false;
    }

    @Override
    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return this._defaultSerializer.withObjectIdWriter(objectIdWriter);
    }

    @Override
    protected BeanSerializerBase withFilterId(Object object) {
        return new BeanAsArraySerializer((BeanSerializerBase)this, this._objectIdWriter, object);
    }

    @Override
    protected BeanAsArraySerializer withIgnorals(String[] stringArray) {
        return new BeanAsArraySerializer((BeanSerializerBase)this, stringArray);
    }

    @Override
    protected BeanSerializerBase asArraySerializer() {
        return this;
    }

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
        this._defaultSerializer.serializeWithType(object, jsonGenerator, serializerProvider, typeSerializer);
    }

    @Override
    public final void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) && this.hasSingleElement(serializerProvider)) {
            this.serializeAsArray(object, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray();
        this.serializeAsArray(object, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    private boolean hasSingleElement(SerializerProvider serializerProvider) {
        BeanPropertyWriter[] beanPropertyWriterArray = this._filteredProps != null && serializerProvider.getActiveView() != null ? this._filteredProps : this._props;
        return beanPropertyWriterArray.length == 1;
    }

    protected final void serializeAsArray(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        int n;
        BeanPropertyWriter[] beanPropertyWriterArray = this._filteredProps != null && serializerProvider.getActiveView() != null ? this._filteredProps : this._props;
        try {
            for (BeanPropertyWriter beanPropertyWriter : beanPropertyWriterArray) {
                if (beanPropertyWriter == null) {
                    jsonGenerator.writeNull();
                    continue;
                }
                beanPropertyWriter.serializeAsElement(object, jsonGenerator, serializerProvider);
            }
        }
        catch (Exception exception) {
            String string = n == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n].getName();
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, string);
        }
        catch (StackOverflowError stackOverflowError) {
            JsonMappingException jsonMappingException = new JsonMappingException("Infinite recursion (StackOverflowError)", stackOverflowError);
            String string = n == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n].getName();
            jsonMappingException.prependPath(new JsonMappingException.Reference(object, string));
            throw jsonMappingException;
        }
    }

    public String toString() {
        return "BeanAsArraySerializer for " + this.handledType().getName();
    }
}

