/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform;

import java.io.StringWriter;
import java.util.Map;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import net.snowflake.client.jdbc.internal.amazonaws.DefaultRequest;
import net.snowflake.client.jdbc.internal.amazonaws.Request;
import net.snowflake.client.jdbc.internal.amazonaws.http.HttpMethodName;
import net.snowflake.client.jdbc.internal.amazonaws.internal.ListWithAutoConstructFlag;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.EncryptRequest;
import net.snowflake.client.jdbc.internal.amazonaws.transform.Marshaller;
import net.snowflake.client.jdbc.internal.amazonaws.util.StringInputStream;
import net.snowflake.client.jdbc.internal.amazonaws.util.StringUtils;
import net.snowflake.client.jdbc.internal.amazonaws.util.json.JSONWriter;

public class EncryptRequestMarshaller
implements Marshaller<Request<EncryptRequest>, EncryptRequest> {
    @Override
    public Request<EncryptRequest> marshall(EncryptRequest encryptRequest) {
        if (encryptRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<EncryptRequest> request = new DefaultRequest<EncryptRequest>(encryptRequest, "AWSKMS");
        String target = "TrentService.Encrypt";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag grantTokensList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (encryptRequest.getKeyId() != null) {
                jsonWriter.key("KeyId").value(encryptRequest.getKeyId());
            }
            if (encryptRequest.getPlaintext() != null) {
                jsonWriter.key("Plaintext").value(encryptRequest.getPlaintext());
            }
            if (encryptRequest.getEncryptionContext() != null && !encryptRequest.getEncryptionContext().isEmpty()) {
                jsonWriter.key("EncryptionContext");
                jsonWriter.object();
                for (Map.Entry<String, String> encryptionContextListValue : encryptRequest.getEncryptionContext().entrySet()) {
                    if (encryptionContextListValue.getValue() == null) continue;
                    jsonWriter.key(encryptionContextListValue.getKey());
                    jsonWriter.value(encryptionContextListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (!((grantTokensList = (ListWithAutoConstructFlag)encryptRequest.getGrantTokens()) == null || grantTokensList.isAutoConstruct() && grantTokensList.isEmpty())) {
                jsonWriter.key("GrantTokens");
                jsonWriter.array();
                for (String grantTokensListValue : grantTokensList) {
                    if (grantTokensListValue == null) continue;
                    jsonWriter.value(grantTokensListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

