/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform;

import java.io.StringWriter;
import java.util.Map;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import net.snowflake.client.jdbc.internal.amazonaws.DefaultRequest;
import net.snowflake.client.jdbc.internal.amazonaws.Request;
import net.snowflake.client.jdbc.internal.amazonaws.http.HttpMethodName;
import net.snowflake.client.jdbc.internal.amazonaws.internal.ListWithAutoConstructFlag;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.ReEncryptRequest;
import net.snowflake.client.jdbc.internal.amazonaws.transform.Marshaller;
import net.snowflake.client.jdbc.internal.amazonaws.util.StringInputStream;
import net.snowflake.client.jdbc.internal.amazonaws.util.StringUtils;
import net.snowflake.client.jdbc.internal.amazonaws.util.json.JSONWriter;

public class ReEncryptRequestMarshaller
implements Marshaller<Request<ReEncryptRequest>, ReEncryptRequest> {
    @Override
    public Request<ReEncryptRequest> marshall(ReEncryptRequest reEncryptRequest) {
        if (reEncryptRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ReEncryptRequest> request = new DefaultRequest<ReEncryptRequest>(reEncryptRequest, "AWSKMS");
        String target = "TrentService.ReEncrypt";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag grantTokensList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (reEncryptRequest.getCiphertextBlob() != null) {
                jsonWriter.key("CiphertextBlob").value(reEncryptRequest.getCiphertextBlob());
            }
            if (reEncryptRequest.getSourceEncryptionContext() != null && !reEncryptRequest.getSourceEncryptionContext().isEmpty()) {
                jsonWriter.key("SourceEncryptionContext");
                jsonWriter.object();
                for (Map.Entry<String, String> sourceEncryptionContextListValue : reEncryptRequest.getSourceEncryptionContext().entrySet()) {
                    if (sourceEncryptionContextListValue.getValue() == null) continue;
                    jsonWriter.key(sourceEncryptionContextListValue.getKey());
                    jsonWriter.value(sourceEncryptionContextListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (reEncryptRequest.getDestinationKeyId() != null) {
                jsonWriter.key("DestinationKeyId").value(reEncryptRequest.getDestinationKeyId());
            }
            if (reEncryptRequest.getDestinationEncryptionContext() != null && !reEncryptRequest.getDestinationEncryptionContext().isEmpty()) {
                jsonWriter.key("DestinationEncryptionContext");
                jsonWriter.object();
                for (Map.Entry<String, String> destinationEncryptionContextListValue : reEncryptRequest.getDestinationEncryptionContext().entrySet()) {
                    if (destinationEncryptionContextListValue.getValue() == null) continue;
                    jsonWriter.key(destinationEncryptionContextListValue.getKey());
                    jsonWriter.value(destinationEncryptionContextListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (!((grantTokensList = (ListWithAutoConstructFlag)reEncryptRequest.getGrantTokens()) == null || grantTokensList.isAutoConstruct() && grantTokensList.isEmpty())) {
                jsonWriter.key("GrantTokens");
                jsonWriter.array();
                for (String grantTokensListValue : grantTokensList) {
                    if (grantTokensListValue == null) continue;
                    jsonWriter.value(grantTokensListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

