/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerationException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerator;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializerProvider;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public static final ByteBufferSerializer instance = new ByteBufferSerializer();

    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (byteBuffer.hasArray()) {
            jsonGenerator.writeBinary(byteBuffer.array(), 0, byteBuffer.limit());
            return;
        }
        ByteBuffer byteBuffer2 = byteBuffer.asReadOnlyBuffer();
        if (byteBuffer2.position() > 0) {
            byteBuffer2.rewind();
        }
        ByteBufferBackedInputStream byteBufferBackedInputStream = new ByteBufferBackedInputStream(byteBuffer2);
        jsonGenerator.writeBinary(byteBufferBackedInputStream, byteBuffer2.remaining());
        byteBufferBackedInputStream.close();
    }
}

