/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.internal.snowflake.gscommon.core.ResourceBundleManager;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SFException
extends Throwable {
    static final SFLogger logger = SFLoggerFactory.getLogger(SFException.class);
    static final ResourceBundleManager errorResourceBundleManager = ResourceBundleManager.getSingleton("net.snowflake.client.jdbc.jdbc_error_messages");
    private Throwable cause = null;
    private String queryId = null;
    private String sqlState;
    private int vendorCode;
    private Object[] params;

    public SFException(ErrorCode errorCode, Object ... params) {
        super(errorResourceBundleManager.getLocalizedMessage(String.valueOf(errorCode.getMessageCode()), params));
        this.sqlState = errorCode.getSqlState();
        this.vendorCode = errorCode.getMessageCode();
        this.params = params;
    }

    public SFException(Throwable cause, ErrorCode errorCode, Object ... params) {
        super(errorResourceBundleManager.getLocalizedMessage(String.valueOf(errorCode.getMessageCode()), params), cause);
        this.sqlState = errorCode.getSqlState();
        this.vendorCode = errorCode.getMessageCode();
        this.params = params;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getSqlState() {
        return this.sqlState;
    }

    public int getVendorCode() {
        return this.vendorCode;
    }

    public Object[] getParams() {
        return this.params;
    }

    @Override
    public String toString() {
        return super.toString() + (this.getQueryId() != null ? ", query id = " + this.getQueryId() : "") + (this.getSqlState() != null ? ", sql state = " + this.getSqlState() : "");
    }
}

