/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.impl;

import java.io.IOException;
import java.util.HashSet;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonToken;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DeserializationContext;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonDeserializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonMappingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.SettableBeanProperty;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.NameTransformer;

public class BeanAsArrayDeserializer
extends BeanDeserializerBase {
    private static final long serialVersionUID = 1L;
    protected final BeanDeserializerBase _delegate;
    protected final SettableBeanProperty[] _orderedProperties;

    public BeanAsArrayDeserializer(BeanDeserializerBase beanDeserializerBase, SettableBeanProperty[] settableBeanPropertyArray) {
        super(beanDeserializerBase);
        this._delegate = beanDeserializerBase;
        this._orderedProperties = settableBeanPropertyArray;
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer nameTransformer) {
        return this._delegate.unwrappingDeserializer(nameTransformer);
    }

    @Override
    public BeanAsArrayDeserializer withObjectIdReader(ObjectIdReader objectIdReader) {
        return new BeanAsArrayDeserializer(this._delegate.withObjectIdReader(objectIdReader), this._orderedProperties);
    }

    @Override
    public BeanAsArrayDeserializer withIgnorableProperties(HashSet<String> hashSet) {
        return new BeanAsArrayDeserializer(this._delegate.withIgnorableProperties(hashSet), this._orderedProperties);
    }

    @Override
    protected BeanDeserializerBase asArrayDeserializer() {
        return this;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (jsonParser.getCurrentToken() != JsonToken.START_ARRAY) {
            return this._deserializeFromNonArray(jsonParser, deserializationContext);
        }
        if (!this._vanillaProcessing) {
            return this._deserializeNonVanilla(jsonParser, deserializationContext);
        }
        Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n = 0;
        int n2 = settableBeanPropertyArray.length;
        while (true) {
            if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                return object;
            }
            if (n == n2) break;
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[n];
            if (settableBeanProperty != null) {
                try {
                    settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow((Throwable)exception, object, settableBeanProperty.getName(), deserializationContext);
                }
            } else {
                jsonParser.skipChildren();
            }
            ++n;
        }
        if (!this._ignoreAllUnknown) {
            throw deserializationContext.mappingException("Unexpected JSON values; expected at most " + n2 + " properties (in JSON Array)");
        }
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            jsonParser.skipChildren();
        }
        return object;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException, JsonProcessingException {
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object);
        }
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n = 0;
        int n2 = settableBeanPropertyArray.length;
        while (true) {
            if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                return object;
            }
            if (n == n2) break;
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[n];
            if (settableBeanProperty != null) {
                try {
                    settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow((Throwable)exception, object, settableBeanProperty.getName(), deserializationContext);
                }
            } else {
                jsonParser.skipChildren();
            }
            ++n;
        }
        if (!this._ignoreAllUnknown) {
            throw deserializationContext.mappingException("Unexpected JSON values; expected at most " + n2 + " properties (in JSON Array)");
        }
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            jsonParser.skipChildren();
        }
        return object;
    }

    @Override
    public Object deserializeFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        return this._deserializeFromNonArray(jsonParser, deserializationContext);
    }

    protected Object _deserializeNonVanilla(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (this._nonStandardCreation) {
            return this._deserializeWithCreator(jsonParser, deserializationContext);
        }
        Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object);
        }
        Class<?> clazz = this._needViewProcesing ? deserializationContext.getActiveView() : null;
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n = 0;
        int n2 = settableBeanPropertyArray.length;
        while (true) {
            if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                return object;
            }
            if (n == n2) break;
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[n];
            ++n;
            if (settableBeanProperty != null && (clazz == null || settableBeanProperty.visibleInView(clazz))) {
                try {
                    settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow((Throwable)exception, object, settableBeanProperty.getName(), deserializationContext);
                }
                continue;
            }
            jsonParser.skipChildren();
        }
        if (!this._ignoreAllUnknown) {
            throw deserializationContext.mappingException("Unexpected JSON values; expected at most " + n2 + " properties (in JSON Array)");
        }
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            jsonParser.skipChildren();
        }
        return object;
    }

    protected Object _deserializeWithCreator(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingPropertyBased(jsonParser, deserializationContext);
        }
        if (this._beanType.isAbstract()) {
            throw JsonMappingException.from(jsonParser, "Can not instantiate abstract type " + this._beanType + " (need to add/enable type information?)");
        }
        throw JsonMappingException.from(jsonParser, "No suitable constructor found for type " + this._beanType + ": can not instantiate from JSON object (need to add/enable type information?)");
    }

    @Override
    protected final Object _deserializeUsingPropertyBased(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, this._objectIdReader);
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n = settableBeanPropertyArray.length;
        int n2 = 0;
        Object object = null;
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            block17: {
                SettableBeanProperty settableBeanProperty;
                SettableBeanProperty settableBeanProperty2 = settableBeanProperty = n2 < n ? settableBeanPropertyArray[n2] : null;
                if (settableBeanProperty == null) {
                    jsonParser.skipChildren();
                } else if (object != null) {
                    try {
                        settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow((Throwable)exception, object, settableBeanProperty.getName(), deserializationContext);
                    }
                } else {
                    String string = settableBeanProperty.getName();
                    SettableBeanProperty settableBeanProperty3 = propertyBasedCreator.findCreatorProperty(string);
                    if (settableBeanProperty3 != null) {
                        Object object2 = settableBeanProperty3.deserialize(jsonParser, deserializationContext);
                        if (propertyValueBuffer.assignParameter(settableBeanProperty3.getCreatorIndex(), object2)) {
                            try {
                                object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                            }
                            catch (Exception exception) {
                                this.wrapAndThrow((Throwable)exception, this._beanType.getRawClass(), string, deserializationContext);
                                break block17;
                            }
                            if (object.getClass() != this._beanType.getRawClass()) {
                                throw deserializationContext.mappingException("Can not support implicit polymorphic deserialization for POJOs-as-Arrays style: nominal type " + this._beanType.getRawClass().getName() + ", actual type " + object.getClass().getName());
                            }
                        }
                    } else if (!propertyValueBuffer.readIdProperty(string)) {
                        propertyValueBuffer.bufferProperty(settableBeanProperty, settableBeanProperty.deserialize(jsonParser, deserializationContext));
                    }
                }
            }
            ++n2;
        }
        if (object == null) {
            try {
                object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
            }
            catch (Exception exception) {
                this.wrapInstantiationProblem(exception, deserializationContext);
                return null;
            }
        }
        return object;
    }

    protected Object _deserializeFromNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        throw deserializationContext.mappingException("Can not deserialize a POJO (of type " + this._beanType.getRawClass().getName() + ") from non-Array representation (token: " + (Object)((Object)jsonParser.getCurrentToken()) + "): type/property designed to be serialized as JSON Array");
    }
}

